<?php

$this->start_controls_section(
	'8_banner_section',
	[
		'label'     => __( 'Banner', 'webteck' ),
		'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
		'condition'	=> ['layout_style' => ['layout_six']]
	]
);
$this->add_control(
	'bg8',
	[
		'label' 		=> esc_html__( 'background Image', 'webteck' ),
		'type' 			=> \Elementor\Controls_Manager::MEDIA,
		'default' 		=> [
			'url' =>  \Elementor\Utils::get_placeholder_image_src(),
		],
	]
);
$this->add_control(
	'shape8',
	[
		'label' 		=> esc_html__( 'Image Shape', 'webteck' ),
		'type' 			=> \Elementor\Controls_Manager::MEDIA,
	]
);

$repeater = new \Elementor\Repeater();

webteck_media_fields($repeater, 'image', 'Choose Background');
webteck_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXT', 'The Leading Platform Event');
webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA', '2024 Global Business');
webteck_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', '');
webteck_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Purchase Ticket');
webteck_url_fields($repeater, 'button_url', 'Button URL');
webteck_general_fields($repeater, 'button_text2', 'Button 2 Text', 'TEXT', 'Discover More');
webteck_url_fields($repeater, 'button_url2', 'Button 2 URL');

$this->add_control(
	'banners8',
	[
		'label' 		=> __( 'Banners', 'webteck' ),
		'type' 			=> \Elementor\Controls_Manager::REPEATER,
		'fields' 		=> $repeater->get_controls(),
		'default' 		=> [
			[
				'title' 		=> __( 'Your Name', 'webteck' ),
			],
		],
		'title_field' 	=> '{{{ title }}}',
	]
);

$this->end_controls_section();