<?php

$this->start_controls_section(
	'7_banner_section',
	[
		'label'     => __( 'Banner', 'webteck' ),
		'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
		'condition'	=> ['layout_style' => ['layout_five']]
	]
);

$repeater = new \Elementor\Repeater();

webteck_media_fields($repeater, 'image', 'Choose Background');
webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA', '2024 Global Business');
webteck_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', '');
webteck_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Purchase Ticket');
webteck_url_fields($repeater, 'button_url', 'Button URL');

$this->add_control(
	'banners7',
	[
		'label' 		=> __( 'Banners', 'webteck' ),
		'type' 			=> \Elementor\Controls_Manager::REPEATER,
		'fields' 		=> $repeater->get_controls(),
		'default' 		=> [
			[
				'title' 		=> __( 'Your Name', 'webteck' ),
			],
		],
		'title_field' 	=> '{{{ title }}}',
	]
);

    $this->add_control(
        'line7',
        [
            'label' 		=> esc_html__( 'Line Shape Image', 'webteck' ),
            'type' 			=> \Elementor\Controls_Manager::MEDIA,
        ]
    );


	//Review Box 
    $this->add_control(
        'show_client',
        [
            'label' 		=> __( 'Show Client Review Box?', 'webteck' ),
            'type' 			=> \Elementor\Controls_Manager::SWITCHER,
            'label_on' 		=> __( 'Show', 'webteck' ),
            'label_off' 	=> __( 'Hide', 'webteck' ),
            'return_value' 	=> 'yes',
            'default' 		=> 'yes',
            'separator'		=> 'before',
            'condition'		=> [ 
                'layout_style' => [ 'layout_five']
            ],
        ]
    );


    $repeater = new \Elementor\Repeater();

    webteck_media_fields($repeater, 'image', 'Choose Image');

    $this->add_control(
        'gallery7',
        [
            'label' 		=> __( 'Clients Image', 'webteck' ),
            'type' 			=> \Elementor\Controls_Manager::REPEATER,
            'fields' 		=> $repeater->get_controls(),
        ]
    );

    webteck_general_fields($this, 'reviews', 'Reviews', 'TEXTAREA', '');
    webteck_general_fields($this, 'desc', 'Content', 'TEXTAREA', '2000 Client Reviews');

	//Social 
    $this->add_control(
        'show_social',
        [
            'label' 		=> __( 'Show Social?', 'webteck' ),
            'type' 			=> \Elementor\Controls_Manager::SWITCHER,
            'label_on' 		=> __( 'Show', 'webteck' ),
            'label_off' 	=> __( 'Hide', 'webteck' ),
            'return_value' 	=> 'yes',
            'default' 		=> 'yes',
            'separator'		=> 'before',
            'condition'		=> [ 
                'layout_style' => [ 'layout_five']
            ],
        ]
    );

    $this->add_control(
        'social_text',
        [
            'label' 	=> __( 'Social Text', 'webteck' ),
            'type' 		=> \Elementor\Controls_Manager::TEXT,
            'default' 	=> __( 'Follow Us:', 'webteck' ),
            'label_block' => true,
            'condition'		=> [ 
                'layout_style' => [ 'layout_five']
            ],
        ]
    );

    webteck_social_fields($this, 'social_lists', 'Social Lists', ['layout_five']);

$this->end_controls_section();