<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Header Widget .
 *
 */
class Webteck_Header_V3 extends Widget_Base {

	public function get_name() {
		return 'webteckheaderv3';
	}
	public function get_title() {
		return __( 'Header V3', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck_header_elements' ];
	}
	protected function register_controls() {

		$this->start_controls_section (
			'header_section',
			[
				'label' 	=> __( 'Header', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Header Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2'  		=> __( 'Style Two', 'webteck' ),
					'3'  		=> __( 'Style Three', 'webteck' ),
					'4'  		=> __( 'Style Four', 'webteck' ),
					'5'  		=> __( 'Style Five', 'webteck' ),
					'6'  		=> __( 'Style Six', 'webteck' ),
					'7'  		=> __( 'Style Seven', 'webteck' ),
					'8'  		=> __( 'Style Eight', 'webteck' ),
					'9'  		=> __( 'Style Nine', 'webteck' ),
					'10'  		=> __( 'Style Ten', 'webteck' ),
					'11'  		=> __( 'Style Eleven', 'webteck' ),
					'12'  		=> __( 'Style Twelve', 'webteck' ),
					'13'  		=> __( 'Style Thirteen', 'webteck' ),
					'14'  		=> __( 'Style Fourteen', 'webteck' ),
				],
			]
		);

		$this->add_control(
			'show_top_bar',
			[
				'label' 		=> __( 'Show Top Bar?', 'webteck' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'webteck' ),
				'label_off' 	=> __( 'Hide', 'webteck' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [ 
					'layout_style' => [ '2', '6']
				],
			]
		);
		$this->add_control(
			'phone_icon',
			[
				'label' 		=> __( 'Phone Icon', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => [ '2', '6']
				],
			]
		);
		$this->add_control(
			'phone',
			[
				'label' 	=> __( 'Phone Number', 'webteck' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( '+163-654-3569', 'webteck' ),
				'label_block' => true,
				'condition'		=> [ 
					'show_top_bar'  => ['yes'], 
					'layout_style' => [ '2', '6']
				],
			]
		);
		$this->add_control(
			'phone_link',
			[
				'label' 		=> __( 'Phone Link', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => [ '2', '6']
				],
			]
		);
		$this->add_control(
			'email_icon',
			[
				'label' 		=> __( 'Email Icon', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => [ '2', '6']
				],
			]
		);
		$this->add_control(
			'email',
			[
				'label' 	=> __( 'Email Address', 'webteck' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( 'info@webteck.com', 'webteck' ),
				'label_block' => true,
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => [ '2', '6']
				],
			]
		);
		$this->add_control(
			'email_link',
			[
				'label' 		=> __( 'Email Link', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => [ '2', '6']
				],
			]
		);
		$this->add_control(
			'address_icon',
			[
				'label' 		=> __( 'Address Icon', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => [ '2', '6']
				],
			]
		);	
		$this->add_control(
			'address',
			[
				'label' 	=> __( 'Address', 'webteck' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( '138 MacArthur Ave, United States', 'webteck' ),
				'label_block' => true,
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => [ '2', '6']
				],
			]
		);
		$this->add_control(
			'address_link',
			[
				'label' 		=> __( 'Address Link', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => [ '2', '6']
				],
			]
		);

		//Social 
		$this->add_control(
			'show_social',
			[
				'label' 		=> __( 'Show Social?', 'webteck' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'webteck' ),
				'label_off' 	=> __( 'Hide', 'webteck' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'separator'		=> 'before',
				'condition'		=> [ 
					'layout_style' => [ '2', '6']
				],
			]
		);

		$this->add_control(
			'social_text',
			[
				'label' 	=> __( 'Social Text', 'webteck' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( 'Follow Us:', 'webteck' ),
				'label_block' => true,
				'condition'		=> [ 
					'show_social'  => ['yes'], 
					'layout_style' => [ '2', '6']
				],
			]
		);

		webteck_social_fields($this, 'social_lists', 'Social Lists', ['2', '6']);


		//---------------------------- main menu control----------------------------//
		$this->add_control(
			'logo_image',

			[
				'label' 		=> __( 'Upload Logo', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$menus = $this->webteck_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'webteck_menu_select',
				[
					'label'     	=> __( 'Select A Menu', 'webteck' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'webteck' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		} else {
			$this->add_control(
				'no_menu1',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'webteck' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'webteck' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}

        $this->add_control(
			'phone_number',
			[
				'label' 		=> __( 'Phone Number', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' => true,
				'condition'		=> [ 'layout_style' => [ '1', '2', '3', '5', '6', '7', '8', '10' ] ],
			]
		);
        $this->add_control(
			'phone_url',
			[
				'label' 		=> __( 'Phone Number URL', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' => true,
				'condition'		=> [ 'layout_style' => [ '1', '2', '3', '5', '6', '7', '8', '10' ] ],
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' 		=> __( 'Button Text', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __( 'Contact Us', 'webteck' ),
				'condition'		=> [ 
					'layout_style' => [ '4','9', '10', '11', '12','13','14']
				],
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'		=> [ 
					'layout_style' => [ '4','9', '10', '11', '12','13','14']
				],
			]
		);

		$this->add_control(
			'show_offcanvas',
			[
				'label' 		=> __( 'Show Off Canvas?', 'webteck' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'webteck' ),
				'label_off' 	=> __( 'Hide', 'webteck' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [ 
					'layout_style' => [ '4','14']
				],
			]
		);

        $this->end_controls_section();
       
       	//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------General Style-------
		 $this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'Background Styling', 'webteck' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		webteck_color_fields( $this, 'top_bg', 'Topbar Background', 'background', '{{WRAPPER}} .header-top', ['2', '6'] );                    
		webteck_color_fields( $this, 'menu_bg', 'Menu Background', 'background', '{{WRAPPER}} .menu-area', ['1', '2', '3', '4', '5', '6', '7', '8', '10', '11', '12'] );

		$this->end_controls_section();

		//------Menu Bar Style-------
        $this->start_controls_section(
			'menubar_styling2',
			[
				'label'     => __( 'Menu Styling', 'webteck' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		webteck_color_fields( $this, 'menu_color1', 'Color', 'color', '{{WRAPPER}} .main-menu>ul>li>a', ['1'] );
		webteck_color_fields( $this, 'menu_color2', 'Hover Color', 'color', '{{WRAPPER}} .main-menu>ul>li>a:hover', ['1'] );
		webteck_color_fields( $this, 'menu_color3', 'Dropdown Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a' );
		webteck_color_fields( $this, 'menu_color4', 'Dropdown Hover Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a:hover' );
		webteck_color_fields( $this, 'menu_color5', 'Menu Icon Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a:before, {{WRAPPER}} .main-menu ul li.menu-item-has-children > a:after' );

		webteck_typography_fields( $this, 'menu_font', 'Menu Trpography', '{{WRAPPER}} .main-menu>ul>li>a, {{WRAPPER}} .main-menu ul.sub-menu li a' );

		webteck_dimensions_fields( $this, 'menu_margin', 'Menu Margin', 'margin', '{{WRAPPER}} .main-menu>ul>li>a' );
		webteck_dimensions_fields( $this, 'menu_padding', 'Menu Padding', 'padding', '{{WRAPPER}} .main-menu>ul>li>a' );

		$this->end_controls_section();

		//------Button Style-------
		webteck_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th_btn', ['1', '2', '3', '4', '5', '6', '7', '8', '11', '12','13'] );

		
    }

    public function webteck_menu_select(){
	    $webteck_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'webteck' );
	    foreach( $webteck_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}


	protected function render() {

        $settings = $this->get_settings_for_display();

        $webteck_avaiable_menu   = $this->webteck_menu_select();

		if( ! $webteck_avaiable_menu ){
			return;
		}
		$args = [
			'menu'  => $settings['webteck_menu_select'],
            'container'       => 'ul',
            'menu_class'      => '',
		];

		// Header sub-menu icon
		if( class_exists( 'ReduxFramework' ) ){ 
			if(webteck_opt('webteck_sticky_enable')){
				$sticky = '';
			}else{
				$sticky = '-no';
			}

			if(webteck_opt('webteck_menu_icon')){
				$menu_icon = '';
			}else{
				$menu_icon = 'hide-icon';
			}
		}



		//mobile menu
	    echo webteck_mobile_menu();
		//search box
	    echo webteck_search_box();

		
			echo '<div class="sidemenu-wrapper d-none d-lg-block ">';
				echo '<div class="sidemenu-content bg-black2">';
					echo '<button class="closeButton sideMenuCls"><i class="far fa-times"></i></button>';
					if(is_active_sidebar('webteck-offcanvas')){
						dynamic_sidebar( 'webteck-offcanvas' );
					}else{
						echo '<h4 class="widget_title">No Widget Added </h4>';
						echo '<p>Please add some widget in Offcanvs Sidebar</p>';
					}
				echo '</div>';
			echo '</div> ';
		



	    if($settings['layout_style'] == '1' ){
			echo '<div class="th-header header-layout12 onepage-nav">';
				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container4">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
								echo '<div class="col-auto">';
									echo '<div class="header-logo">';
										echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'">';
											echo '<span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span>';
											echo '<img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
										echo '</a>';
									echo '</div>';
								echo '</div>';
								}
								echo '<div class="col-auto">';
									if ( ! empty( $settings['webteck_menu_select'] ) ) {
										echo '<nav class="main-menu style2 d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
											wp_nav_menu( $args );
										echo '</nav>';
									}
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								if( ! empty( $settings['phone_number'] ) ) {
								echo '<div class="col-auto d-xl-block d-none">';
									echo '<div class="header-button">';
										echo '<a href="'.esc_html( $settings['phone_url'] ).'" class="th-btn th_btn style-radius">'.esc_html( $settings['phone_number'] ).'</a>';
									echo '</div>';
								echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		} elseif($settings['layout_style'] == '2' ) {
			echo '<div class="th-header header-layout15 onepage-nav">';
				if(!empty($settings['show_top_bar'])){
				echo '<div class="header-top">';
					echo '<div class="container th-container4">';
						echo '<div class="row justify-content-center justify-content-lg-between align-items-center">';
							echo '<div class="col-auto d-none d-md-block">';
								echo '<div class="header-links">';
									echo '<ul>';
									if(!empty($settings['phone'])){
										echo '<li>';
											if(!empty($settings['phone_icon'])){
												echo wp_kses_post( $settings['phone_icon'] );
											}
											echo '<a href="'.esc_attr($settings['phone_link']).'">'.esc_html($settings['phone']).'</a>';
											echo '</li>';
									}
									if(!empty($settings['address'])){
										echo '<li class="d-none d-xl-inline-block">';
											if(!empty($settings['address_icon'])){
												echo wp_kses_post( $settings['address_icon'] );
											}
											echo '<a href="'.esc_attr($settings['address_link']).'">'.esc_html($settings['address']).'</a>';
										echo '</li>';
									}
									if(!empty($settings['email'])){
										echo '<li>';
											if(!empty($settings['email_icon'])){
												echo wp_kses_post( $settings['email_icon'] );
											}
											echo '<a href="'.esc_attr($settings['email_link']).'">'.esc_html($settings['email']).'</a>';
										echo '</li>';
									}
									echo '</ul>';
								echo '</div>';
							echo '</div>';
							if(!empty( $settings['show_social'])){
								echo '<div class="col-auto">';
									echo '<div class="social-links">';
										if(!empty($settings['social_text'])){
											echo '<span class="social-title">'.esc_html($settings['social_text']).'</span>';
										}
										foreach( $settings['social_lists'] as $social_icon ){
											$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
											$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

											echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

											\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
						
											echo '</a> ';
										}
									echo '</div>';
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
				}
				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container4">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'">';
												echo '<span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span>';
												echo '<img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
											echo '</a>';
										echo '</div>';
									echo '</div>';
								}
								echo '<div class="col-auto">';
									if ( ! empty( $settings['webteck_menu_select'] ) ) {
										echo '<nav class="main-menu style2 d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
											wp_nav_menu( $args );
										echo '</nav>';
									}
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								if( ! empty( $settings['phone_number'] ) ) {
									echo '<div class="col-auto d-xl-block d-none">';
										echo '<div class="header-button">';
											echo '<a href="'.esc_html( $settings['phone_url'] ).'" class="th-btn th_btn style-radius">'.esc_html( $settings['phone_number'] ).'</a>';
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		} elseif($settings['layout_style'] == '3' ){
			echo '<div class="th-header header-layout13 onepage-nav">';
				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container4">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
								echo '<div class="col-auto">';
									echo '<div class="header-logo">';
										echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'">';
											echo '<span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span>';
											echo '<img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
										echo '</a>';
									echo '</div>';
								echo '</div>';
								}
								echo '<div class="col-auto">';
									if ( ! empty( $settings['webteck_menu_select'] ) ) {
										echo '<nav class="main-menu style2 d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
											wp_nav_menu( $args );
										echo '</nav>';
									}
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								if( ! empty( $settings['phone_number'] ) ) {
								echo '<div class="col-auto d-xl-block d-none">';
									echo '<div class="header-button">';
										echo '<a href="'.esc_html( $settings['phone_url'] ).'" class="th-btn th_btn style-radius">'.esc_html( $settings['phone_number'] ).'</a>';
									echo '</div>';
								echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		} elseif($settings['layout_style'] == '4' ){
			echo '<div class="th-header header-layout18 header-absolute onepage-nav">';
				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container4">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'">';
												echo '<span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span>';
												echo '<img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
											echo '</a>';
										echo '</div>';
									echo '</div>';
								}
								echo '<div class="col-auto">';
									if ( ! empty( $settings['webteck_menu_select'] ) ) {
										echo '<nav class="main-menu d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
											wp_nav_menu( $args );
										echo '</nav>';
									}
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								echo '<div class="col-auto d-none d-xl-inline-block">';
									echo '<div class="header-button">';
										if(!empty( $settings['button_text'])){
											echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style-radius style3 text-capitalize th_btn">'.wp_kses_post($settings['button_text']).'</a>';
										}
										if(!empty($settings['show_offcanvas'])){
											echo '<a href="#" class="icon-btn sideMenuToggler"><i class="fal fa-bars"></i></a>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		} elseif($settings['layout_style'] == '5' ){
			echo '<div class="th-header header-layout17 onepage-nav>';
				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container4">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'">';
												echo '<span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span>';
												echo '<img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
											echo '</a>';
										echo '</div>';
									echo '</div>';
									}
								echo '<div class="col-auto">';
									if ( ! empty( $settings['webteck_menu_select'] ) ) {
										echo '<nav class="main-menu style2 d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
											wp_nav_menu( $args );
										echo '</nav>';
									}
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								if( ! empty( $settings['phone_number'] ) ) {
									echo '<div class="col-auto d-none d-xl-inline-block">';
										echo '<div class="header-button">';
											echo '<a href="'.esc_html( $settings['phone_url'] ).'" class="th-btn style-radius text-capitalize th_btn">'.esc_html( $settings['phone_number'] ).'</a>';
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		} elseif($settings['layout_style'] == '6' ){
			echo '<div class="th-header header-layout19 onepage-nav">';
				if(!empty($settings['show_top_bar'])){
				echo '<div class="header-top">';
					echo '<div class="container th-container4">';
						echo '<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">';
							echo '<div class="col-auto d-none d-lg-block">';
								echo '<div class="header-links">';
									echo '<ul>';
										if(!empty($settings['phone'])){
											echo '<li>';
												if(!empty($settings['phone_icon'])){
													echo wp_kses_post( $settings['phone_icon'] );
												}
												echo '<a href="'.esc_attr($settings['phone_link']).'">'.esc_html($settings['phone']).'</a>';
												echo '</li>';
										}
										if(!empty($settings['address'])){
											echo '<li class="d-none d-xl-inline-block">';
												if(!empty($settings['address_icon'])){
													echo wp_kses_post( $settings['address_icon'] );
												}
												echo '<a href="'.esc_attr($settings['address_link']).'">'.esc_html($settings['address']).'</a>';
											echo '</li>';
										}
										if(!empty($settings['email'])){
											echo '<li>';
												if(!empty($settings['email_icon'])){
													echo wp_kses_post( $settings['email_icon'] );
												}
												echo '<a href="'.esc_attr($settings['email_link']).'">'.esc_html($settings['email']).'</a>';
											echo '</li>';
										}
									echo '</ul>';
								echo '</div>';
							echo '</div>';
							if(!empty( $settings['show_social'])){
								echo '<div class="col-auto">';
									echo '<div class="header-social">';
										if(!empty($settings['social_text'])){
											echo '<span class="social-title">'.esc_html($settings['social_text']).'</span>';
										}
										foreach( $settings['social_lists'] as $social_icon ){
											$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
											$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

											echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

											\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
						
											echo '</a> ';
										}
									echo '</div>';
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
				}
				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container4">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'">';
												echo '<span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span>';
												echo '<img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
											echo '</a>';
										echo '</div>';
									echo '</div>';
								}
								echo '<div class="col-auto">';
									if ( ! empty( $settings['webteck_menu_select'] ) ) {
										echo '<nav class="main-menu style2 d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
											wp_nav_menu( $args );
										echo '</nav>';
									}
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								if( ! empty( $settings['phone_number'] ) ) {
									echo '<div class="col-auto d-xl-block d-none">';
										echo '<div class="header-button">';
											echo '<a href="'.esc_html( $settings['phone_url'] ).'" class="th-btn th-gradient-btn style-radius text-capitalize th_btn">'.esc_html( $settings['phone_number'] ).'</a>';
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		} elseif($settings['layout_style'] == '7' ){
			echo '<div class="th-header header-layout21 onepage-nav">';
				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container4">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'">';
												echo '<span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span>';
												echo '<img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
											echo '</a>';
										echo '</div>';
									echo '</div>';
								}
								echo '<div class="col-auto">';
									if ( ! empty( $settings['webteck_menu_select'] ) ) {
										echo '<nav class="main-menu style2 d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
											wp_nav_menu( $args );
										echo '</nav>';
									}
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								if( ! empty( $settings['phone_number'] ) ) {
									echo '<div class="col-auto d-xl-block d-none">';
										echo '<div class="header-button">';
											echo '<a href="'.esc_html( $settings['phone_url'] ).'" class="th-btn style3 style-radius th_btn">'.esc_html( $settings['phone_number'] ).'</a>';
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		} elseif($settings['layout_style'] == '8' ){
			echo '<div class="th-header header-layout9 header-absolute onepage-nav">';
				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'">';
												echo '<span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span>';
												echo '<img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
											echo '</a>';
										echo '</div>';
									echo '</div>';
								}
								echo '<div class="col-auto">';
									if ( ! empty( $settings['webteck_menu_select'] ) ) {
										echo '<nav class="main-menu style2 d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
											wp_nav_menu( $args );
										echo '</nav>';
									}
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								if( ! empty( $settings['phone_number'] ) ) {
									echo '<div class="col-auto d-xl-block d-none">';
										echo '<div class="header-button">';
											echo '<a href="'.esc_html( $settings['phone_url'] ).'" class="th-btn btn-gradient style-radius th_btn">'.esc_html( $settings['phone_number'] ).'</a>';
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif($settings['layout_style'] == '9' ){
			echo '<div class="th-header header-layout23 header-absolute onepage-nav">';
		        echo '<div class="sticky-wrapper  '.esc_attr($sticky).'">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="menu-area">';
		                echo '<div class="container th-container4">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                    	if( ! empty( $settings['logo_image']['url'] ) ){
			                        echo '<div class="col-auto">';
			                            echo '<div class="header-logo">';
			                                echo '<a class="" href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="Webteck"></a>';
			                            echo '</div>';
			                        echo '</div>';
			                    }
			                    if ( ! empty( $settings['webteck_menu_select'] ) ) {
			                        echo '<div class="col-auto">';
			                            echo '<nav class="main-menu style2 d-none d-lg-inline-block  '.esc_attr($menu_icon).'">';
			                                wp_nav_menu( $args );
			                            echo '</nav>';
			                        echo '</div>';
			                    }
		                        echo '<div class="col-auto">';
		                        	if(!empty( $settings['button_text'])){
			                            echo '<div class="header-button d-none d-lg-inline-block">';
			                                echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn btn-gradient2 style-radius">'.wp_kses_post($settings['button_text']).'</a>';
			                            echo '</div>';
			                        }
		                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		}elseif($settings['layout_style'] == '10' ){
			echo '<header class="th-header header-layout24">';
				echo '<div class="sticky-wrapper">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="icon-masking" href="'.esc_url( home_url( '/' ) ).'"><span data-mask-src="'.esc_url( $settings['logo_image']['url'] ).'" class="mask-icon"></span><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="Webteck"></a>';
										echo '</div>';
									echo '</div>';
								}
								if ( ! empty( $settings['webteck_menu_select'] ) ) {
			                        echo '<div class="col-auto">';
			                            echo '<nav class="main-menu style2 d-none d-lg-inline-block  '.esc_attr($menu_icon).'">';
			                                wp_nav_menu( $args );
			                            echo '</nav>';
										echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
			                        echo '</div>';
			                    }
								echo '<div class="col-auto d-xl-block d-none">';
									echo '<div class="header-button">';
										if( ! empty( $settings['phone_number'] ) ) {
											echo '<a href="'.esc_html( $settings['phone_url'] ).'" class="th-btn2 th_btn2"><span>'.esc_html( $settings['phone_number'] ).'</span><span class="icon"><i class="fa-solid fa-phone"></i></span></a>';
										}
										if(!empty( $settings['button_text'])){
											echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn2 blue-btn style-radius text-capitalize th_btn">'.wp_kses_post($settings['button_text']).'</a>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</header>';

		}elseif($settings['layout_style'] == '11' ){
			echo '<div class="th-menu-wrapper2">'; 
				echo '<div class="th-menu-area text-center">';
					echo '<button class="th-menu-toggle2"><i class="fal fa-times"></i></button>';
					echo '<div class="mobile-logo">';
						echo '<a class="" href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'"></a>';
					echo '</div>';
					echo '<div class="th-mobile-menu onepage-nav">';
						if ( ! empty( $settings['webteck_menu_select'] ) ) {
							echo '<div class="th-mobile-menu">';
								wp_nav_menu( $args );
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';

			echo '<div class="th-header header-layout26 header-absolute  onepage-nav">';
				echo '<div class="sticky-wrapper">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container4">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="" href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'"></a>';
										echo '</div>';
									echo '</div>';
								}
								if ( ! empty( $settings['webteck_menu_select'] ) ) {
			                        echo '<div class="col-auto">';
			                            echo '<nav class="main-menu style2 d-none d-lg-inline-block  '.esc_attr($menu_icon).'">';
			                                wp_nav_menu( $args );
			                            echo '</nav>';
			                        echo '</div>';
			                    }
								echo '<div class="col-auto">';
									if(!empty( $settings['button_text'])){
										echo '<div class="header-button d-none d-xl-inline-block">';
											echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style11 text-capitalize style-radius th_btn">'.wp_kses_post($settings['button_text']).'</a>';
										echo '</div>';
									}
									echo '<button type="button" class="th-menu-toggle2 d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif($settings['layout_style'] == '12' ){
			echo '<header class="th-header header-layout27 header-absolute  onepage-nav">';
				echo '<div class="sticky-wrapper">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="container th-container6">';
						echo '<div class="menu-area">';
							echo '<div class="row align-items-center justify-content-between">';
								if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="" href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'"></a>';
										echo '</div>';
									echo '</div>';
								}
								if ( ! empty( $settings['webteck_menu_select'] ) ) {
			                        echo '<div class="col-auto">';
			                            echo '<nav class="main-menu style2 d-none d-lg-inline-block  '.esc_attr($menu_icon).'">';
			                                wp_nav_menu( $args );
			                            echo '</nav>';
			                        echo '</div>';
			                    }
								echo '<div class="col-auto">';
									if(!empty( $settings['button_text'])){
										echo '<div class="header-button d-none d-xl-inline-block">';
											echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style3 text-title style-radius th_btn">'.wp_kses_post($settings['button_text']).'</a>';
										echo '</div>';
									}
									echo '<button type="button" class="th-menu-toggle2 d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</header>';
		}elseif($settings['layout_style'] == '13' ){
			echo '<header class="th-header header-layout27 header-absolute  onepage-nav">';
		        echo '<div class="sticky-wrapper">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="container th-container6">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                    	if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="" href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'"></a>';
										echo '</div>';
									echo '</div>';
								}

								if ( ! empty( $settings['webteck_menu_select'] ) ) {
			                        echo '<div class="col-auto">';
			                            echo '<nav class="main-menu d-none d-lg-inline-block  '.esc_attr($menu_icon).'">';
			                                wp_nav_menu( $args );
			                            echo '</nav>';
			                        echo '</div>';
			                    }
			                    if(!empty( $settings['button_text'])){
			                        echo '<div class="col-auto">';
			                            echo '<div class="header-button d-none d-xl-inline-block">';
			                                echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style3 text-title style-radius">'.wp_kses_post($settings['button_text']).'</a>';
			                            echo '</div>';
			                            echo '<button type="button" class="th-menu-toggle2 d-block d-lg-none"><i class="far fa-bars"></i></button>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</header>';
		}else{
			echo '<header class="th-header header-layout28 header-absolute">';
		        echo '<div class="sticky-wrapper">';
		            echo '<!-- Main Menu Area -->';
		            echo '<div class="container-fiuld">';
		                echo '<div class="menu-area">';
		                	if(!empty($settings['show_offcanvas'])){
			                    echo '<div class="header-left-button">';
			                        echo '<a href="#" class="simple-btn sideMenuToggler"><img src="'.WEBTECK_PLUGDIRURI.'assets/img/menu.svg" alt=""></a>';
			                    echo '</div>';
			                }
		                    echo '<div class="row align-items-center justify-content-between">';
		                    	if( ! empty( $settings['logo_image']['url'] ) ){
									echo '<div class="col-auto">';
										echo '<div class="header-logo">';
											echo '<a class="" href="'.esc_url( home_url( '/' ) ).'"><img src="'.esc_url( $settings['logo_image']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'"></a>';
										echo '</div>';
									echo '</div>';
								}
								if ( ! empty( $settings['webteck_menu_select'] ) ) {
			                        echo '<div class="col-auto">';
			                            echo '<nav class="main-menu style2 d-none d-lg-inline-block  '.esc_attr($menu_icon).'">';
			                                wp_nav_menu( $args );
			                            echo '</nav>';
			                        echo '</div>';
			                    }
			                    if(!empty( $settings['button_text'])){
			                        echo '<div class="col-auto">';
			                            echo '<div class="header-button d-none d-lg-inline-block">';
			                                echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style3 style-radius">'.wp_kses_post($settings['button_text']).'</a>';
			                            echo '</div>';
			                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</header>';
		}
	}
}
