<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Banner Box Widget .
 *
 */
class Webteck_Banner extends Widget_Base {

	public function get_name() {
		return 'webteckbanner';
	}
	public function get_title() {
		return __( 'Webteck Banner v2', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'bannerd_section',
			[
				'label' 	=> __( 'Banner', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Layout Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'webteck' ),
					'layout_two'  		=> __( 'Style Two', 'webteck' ),
					'layout_three'  	=> __( 'Style Three', 'webteck' ),
					'layout_four'  		=> __( 'Style Four', 'webteck' ),
					'layout_five'  		=> __( 'Style Five', 'webteck' ),
					'layout_six'  		=> __( 'Style Six', 'webteck' ),
					'layout_seven'  	=> __( 'Style Seven', 'webteck' ),
				]
			]
		);
		
        $this->end_controls_section();

	    include webteck_get_elementor_option('banner-three-options.php');
	    include webteck_get_elementor_option('banner-four-options.php');
	    include webteck_get_elementor_option('banner-five-options.php');
	    include webteck_get_elementor_option('banner-six-options.php');
	    include webteck_get_elementor_option('banner-seven-options.php');
	    include webteck_get_elementor_option('banner-eight-options.php');


		
		$this->start_controls_section(
			'bannerd_section22',
			[
				'label' 	=> __( 'Banner', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		webteck_media_fields($this, 'bg', 'Choose Background');

		$repeater = new Repeater();

		webteck_media_fields($repeater, 'image', 'Choose Image');
		webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'We offer home');
		webteck_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', '');
		webteck_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Get started');
		webteck_url_fields($repeater, 'button_url', 'Button URL');
		webteck_general_fields($repeater, 'button_text2', 'Button Text 2', 'TEXT', 'Explore All');
		webteck_url_fields($repeater, 'button_url2', 'Button URL 2');

		webteck_media_fields($repeater, 'image2', 'Client Image');
		webteck_general_fields($repeater, 'title2', 'Client Title', 'TEXTAREA', '5 k+ Real Clients');
		
		$this->add_control(
			'banner_slides7',
			[
				'label' 		=> __( 'Banners', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'We offer home', 'webteck' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['layout_seven']
				]
			]
		);

		$repeater = new Repeater();

		webteck_general_fields($repeater, 'counter_title', 'Title', 'TEXTAREA', '10');
		webteck_general_fields($repeater, 'counter_desc', 'Description', 'TEXTAREA', 'Year’s of Experience');
		
		$this->add_control(
			'banner_counter',
			[
				'label' 		=> __( 'Banners Features', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['layout_seven']
				]
			]
		);

		$this->end_controls_section();

        //-------------------------------------title styling-------------------------------------//
        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Style', 'webteck' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		webteck_all_elementor_style($this, 'Subtitle', '{{WRAPPER}} .banner-subtitle',['layout_one','layout_two'], '--white-color' );
		webteck_all_elementor_style($this, 'Title', '{{WRAPPER}} .banner-title',['layout_one','layout_two','layout_three'], '--white-color' );

		webteck_all_elementor_style($this, 'Description ', '{{WRAPPER}} .banner-desc',['layout_one',], '--white-color' );

        $this->end_controls_section();

		webteck_common_style_fields($this, 'subtitle2', 'Subtitle', '{{WRAPPER}} .sub-title', ['layout_four'] );
		webteck_common_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .hero-title', ['layout_four', 'layout_five', 'layout_six'] );
		webteck_common_style_fields($this, 'desc2', 'Description', '{{WRAPPER}} .hero-text', ['layout_four', 'layout_five', 'layout_six'] );

		//------Button Style-------
		webteck_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th_btn', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six'] );
		webteck_button_style_fields( $this, '13', 'Button Styling', '{{WRAPPER}} .th_btn2', ['layout_three', 'layout_four', 'layout_six'] );
       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
        	echo '<div class="th-hero-wrapper hero-5" id="hero">';
		        echo '<div class="hero-inner">';
		            echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $settings['img5']['url'] ).'">';
		            echo '</div>';
		            echo '<div class="container th-container5">';
		                echo '<div class="hero-style5">';
		                    echo '<span class="sub-title style1 text-white banner-subtitle">'.esc_html( $settings['title5'] ).'</span>';
                            echo '<h1 class="hero-title text-white banner-title">'.esc_html( $settings['subtitle5'] ).'</h1>';
                            echo '<p class="hero-text text-white banner-desc">'.esc_html( $settings['desc5'] ).'</p>';
                            if( !empty( $settings['button_link5'] ) ){
                                echo '<div class="btn-group mt-35">';
                                    echo '<a href="'.esc_url($settings['button_link5']).'" class="th-btn style6 style-radius th_btn">'.esc_html($settings['button_text5']).'</a>';
                                echo '</div>';
                            }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="th-hero-wrapper hero-6" id="hero">'; ?>
		        <div class="swiper th-slider" id="heroSlide3" data-slider-options='{"effect":"fade"}'><?php
		            echo '<div class="swiper-wrapper">';
		                
		            	foreach( $settings['banners3'] as $data ) { 
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                        echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['img']['url'] ).'">';
			                            echo '<img src="'.esc_url( $settings['overlay']['url'] ).'" alt="Hero Image">';
			                        echo '</div>';
			                        echo '<div class="container">';
			                            echo '<div class="hero-style6">';
			                                echo '<span class="sub-title banner-subtitle" data-ani="slideinup" data-ani-delay="0.5s">'.esc_html( $data['title'] ).'</span>';
			                                echo '<h1 class="hero-title banner-title" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html( $data['subtitle'] ).'</h1>';
			                                echo '<div class="hero-big"><h1 class="hero-big_text">'.esc_html( $data['shadow'] ).'</h1></div>';
			                                echo '<div class="btn-group justify-content-center">';
			                                	echo '<div class="" data-ani="slideinleft" data-ani-delay="0.8s">';
			                                	if( !empty( $data['button_link'] ) ){
				                                    echo '<a href="'.esc_url($data['button_link']).'" class="th-btn style3 style-radius th_btn">'.esc_html($data['button_text']).'</a>';
				                                }
				                                echo '</div>';
				                                if( !empty( $data['video_link'] ) ){
				                                    echo '<div class="call-btn" data-ani="slideinright" data-ani-delay="0.9s">';
				                                        echo '<a href="'.esc_url($data['video_link']).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
				                                        echo '<div class="media-body"><a href="'.esc_url($data['video_link']).'" class="btn-title popup-video">'.esc_html($data['video_text']).'</a></div>';
				                                    echo '</div>';
				                                }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		        echo '<button data-slider-prev="#heroSlide3" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
		        echo '<button data-slider-next="#heroSlide3" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
		    echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_three' ){
	    	echo '<div class="th-hero-wrapper hero-12" id="hero" data-bg-src="'.esc_url( $settings['overlay2']['url'] ).'">';
		        echo '<div class="swiper th-slider" id="heroSlide3" data-slider-options=\'{"effect":"fade"}\'>';
		            echo '<div class="swiper-wrapper">';
		            	foreach( $settings['banners5'] as $data ) {
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                        echo '<div class="container th-container4">';
			                            echo '<div class="hero-style12">';
			                                echo '<h1 class="hero-title banner-title" data-ani="slideinup" data-ani-delay="0.6s">'.wp_kses_post( $data['title'] ).'</h1>';
			                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.9s">';
			                                	if( !empty( $data['button_link'] ) ){
				                                    echo '<a href="'.esc_url($data['button_link']).'" class="th-btn style3 style-radius text-capitalize th_btn">'.esc_html($data['button_text']).'</a>';
				                                }
				                                if( !empty( $data['button_link2'] ) ){
				                                    echo '<a href="'.esc_url($data['button_link2']).'" class="th-btn blue-border style-radius text-capitalize th_btn2">'.esc_html($data['button_text2']).'</a>';
				                                }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                    echo '<div class="th-hero-img">';
			                        echo '<img src="'.esc_url( $data['img']['url'] ).'" alt="">';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		            echo '<div class="container th-container4">';
		                echo '<div class="row">';
		                    echo '<div class="col-12">';
		                        echo '<div class="hero-watch-area">';
		                            echo '<div class="btn-group justify-content-center justify-content-md-between">';
		                                echo '<div class="call-btn hero-btn">';
		                                	if( !empty( $settings['video_link'] ) ){
			                                    echo '<a href="'.esc_url($settings['video_link']).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
			                                    echo '<div class="media-body">';
			                                        echo '<a href="'.esc_url($settings['video_link']).'" class="btn-title popup-video">'.esc_html($settings['video_text']).'</a>';
			                                    echo '</div>';
			                                }
		                                echo '</div>';
		                                if( !empty( $settings['button_link'] ) ){
		                                    echo '<a href="'.esc_url($settings['button_link']).'" class="th-btn style5 style-radius text-capitalize">'.esc_html($settings['button_text']).'</a>';
		                                }
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';

		    echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_four' ){
			echo '<div class="th-hero-wrapper hero-19" id="hero" data-bg-src="'.esc_url( $settings['bg6']['url'] ).'">';
				echo '<div class="hero19-overlay" data-bg-src="'.esc_url( $settings['overlay6']['url'] ).'"></div>';
				echo '<div class="swiper th-slider" id="heroSlide19" data-slider-options=\'{"effect":"fade"}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['banners6'] as $data ) {
						echo '<div class="swiper-slide">';
							echo '<div class="hero-inner">';
								echo '<div class="container th-container4">';
									echo '<div class="row align-items-end">';
										echo '<div class="col-xl-7">';
											echo '<div class="hero-style19">';
												if(!empty($data['subtitle'])){
													echo '<span class="sub-title text-capitalize" data-ani="slideinup" data-ani-delay="0.2s">';
													if (!empty($data['sub_image']['url'])) {
														echo '<div class="icon-masking me-2">';
															echo '<span class="mask-icon" data-mask-src="'.esc_url( $data['sub_image']['url'] ).'"></span>';
															echo webteck_img_tag( array(
																'url'   => esc_url( $data['sub_image']['url']  ),
															));
														echo '</div>';
													}
														echo esc_html($data['subtitle']);
													echo '</span>';
												}
												if(!empty($data['title'])){
													echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">'.esc_html($data['title']).'</h1>';
												}
												if(!empty($data['desc'])){
													echo '<p class="hero-text" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html($data['desc']).'</p>';
												}
												echo '<div class="btn-group justify-content-center justify-content-xl-start " data-ani="slideinup" data-ani-delay="0.9s">';
													if(!empty($data['button_text'])){
														echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style-radius style3 text-capitalize th_btn">'.wp_kses_post($data['button_text']).'</a>';
													}
													if(!empty($data['button_text2'])){
														echo '<a href="'.esc_url( $data['button_url2']['url'] ).'" class="th-btn style-radius style2 text-capitalize th_btn2">'.wp_kses_post($data['button_text2']).'</a>';
													}
												echo '</div>';
											echo '</div>';
										echo '</div>';
										echo '<div class="col-xl-5">';
											if (!empty($data['image']['url'])) {
											echo '<div class="th-hero-img" data-ani="slideinup" data-ani-delay="0.10s">';
												echo webteck_img_tag( array(
													'url'   => esc_url( $data['image']['url']  ),
												));
											echo '</div>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
						}
					echo '</div>';
					echo '<div class="slider-pagination"></div>';
					echo '<div class="icon-box">';
						echo '<button data-slider-prev="#heroSlide19" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
						echo '<button data-slider-next="#heroSlide19" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_five' ){
			echo '<div class="th-hero-wrapper hero-18" id="hero">';
				echo '<div class="swiper th-slider" id="heroSlide18" data-slider-options=\'{"effect":"fade"}\'>';
					echo '<div class="swiper-wrapper">';
					foreach( $settings['banners7'] as $data ) {
						echo '<div class="swiper-slide">';  
							echo '<div class="hero-inner">';  
								echo '<div class="container th-container4">';  
									echo '<div class="hero-style18">';  
										if(!empty($data['title'])){
											echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">'.wp_kses_post($data['title']).'</h1>';
										}
										if(!empty($data['desc'])){
											echo '<p class="hero-text" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html($data['desc']).'</p>';
										}
										if(!empty($data['button_text'])){
											echo '<div class="btn-group justify-content-center" data-ani="slideinup" data-ani-delay="0.9s">'; 
												echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style-radius text-capitalize th_btn">'.wp_kses_post($data['button_text']).'</a>'; 
											echo '</div>';  
										}
									echo '</div>';  
								echo '</div>';  
							echo '</div>';  
							echo '<div class="th-hero-img">';  
								echo webteck_img_tag( array(
									'url'   => esc_url( $data['image']['url']  ),
								));
								if(!empty( $settings['show_client'])){
								echo '<div class="about-client-box style2 mb-sm-0 mb-3">';  
									echo '<div class="client-thumb-group">';  
									foreach( $settings['gallery7'] as $data ) {
										echo '<div class="thumb">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $data['image']['url']  ),
											));
										echo '</div>';  
									}
									echo '</div>';  
									echo '<div class="cilent-box">';  
										if(!empty($settings['reviews'])){
											echo '<div class="about_review">'.wp_kses_post($settings['reviews']).'</div>';
										}  
										if(!empty($settings['desc'])){
											echo '<h4 class="cilent-box_counter">'.wp_kses_post($settings['desc']).'</h4>';
										}  
									echo '</div>';  
								echo '</div>';  
								}
							echo '</div>';  
						echo '</div>';  
					}
					echo '</div>';
					echo '<div class="slider-pagination"></div>';
				echo '</div>';
				if(!empty( $settings['show_social'])){
				echo '<div class="social-links">';
					if(!empty($settings['social_text'])){
						echo '<span class="social-title">'.esc_html($settings['social_text']).'</span>';
					}
					foreach( $settings['social_lists'] as $social_icon ){
						$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
						$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

						echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

						\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
	
						echo '</a> ';
					}
				echo '</div>';
				}
				if (!empty($settings['line7']['url'])) {
				echo '<div class="ripple-shape">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['line7']['url']  ),
					));
				echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_six' ){
			echo '<div class="th-hero-wrapper hero-11" id="hero" data-bg-src="'.esc_url( $settings['bg8']['url'] ).'">';
				echo '<div class="swiper th-slider number-dots hero-slider-11" id="heroSlide3" data-slider-options=\'{"effect":"fade"}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['banners8'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="hero-inner">';
									echo '<div class="container th-container4">';
										echo '<div class="row align-items-center">';
											echo '<div class="col-xl-7">';
												echo '<div class="hero-style11">';
													if(!empty($data['subtitle'])){
														echo '<span class="sub-title" data-ani="slideindown" data-ani-delay="0.1s">'.esc_html($data['subtitle']).'</span>';
													}
													if(!empty($data['title'])){
														echo '<h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.4s">'.esc_html($data['title']).'</h1>';
													}
													if(!empty($data['desc'])){
														echo '<p class="hero-text" data-ani="slideinleft" data-ani-delay="0.4s">'.esc_html($data['desc']).'</p>';
													}
													echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.8s">';
														if(!empty($data['button_text'])){
															echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn btn-gradient style-radius th_btn">'.wp_kses_post($data['button_text']).'</a>';
														}
														if(!empty($data['button_text2'])){
															echo '<a href="'.esc_url( $data['button_url2']['url'] ).'" class="th-btn style2 style-radius text-capitalize th_btn2">'.wp_kses_post($data['button_text2']).'</a>';
														}
													echo '</div>';

												echo '</div>';
											echo '</div>';
											echo '<div class="col-xl-5">';
												echo '<div class="th-hero-wrapp">';
													if (!empty($data['image']['url'])) {
														echo '<div class="th-hero-img" data-ani="slideinup" data-ani-delay="0.8s" data-bg-src="'.esc_url( $settings['shape8']['url'] ).'">';
															echo webteck_img_tag( array(
																'url'   => esc_url( $data['image']['url']  ),
															));
														echo '</div>';
													}
													echo '<div class="hero11-shape style1"></div>';
													echo '<div class="hero11-shape style2"></div>';
													echo '<div class="hero11-shape style3"></div>';
													echo '<div class="hero11-shape style4"></div>';
												echo '</div>';
											echo '</div>';
										echo '</div>';

									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<div class="slider-pagination"></div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_seven' ){ 
			echo '<div class="th-hero-wrapper hero-24 position-relative" id="hero" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
				echo '<div class="hero-overlay"></div>';
				echo '<div class="swiper th-slider" id="heroSlide23" data-slider-options=\'{"effect":"fade","loop":true,"paginationType":"progressbar"}\'>';
					echo '<div class="swiper-wrapper">';
					foreach( $settings['banner_slides7'] as $data ){
						echo '<div class="swiper-slide">';
							echo '<div class="hero-inner">';
								echo '<div class="container th-container4">';
									echo '<div class="row">';
										echo '<div class="col-xl-6">';
											echo '<div class="hero-style24">';
												if(!empty($data['title'])){
													echo '<h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.4s">'.wp_kses_post($data['title']).'</h1>';
												}
												if(!empty($data['desc'])){
													echo '<p class="hero-text" data-ani="slideinleft" data-ani-delay="0.6s">'.wp_kses_post($data['desc']).'</p>';
												}
												echo '<div class="btn-group justify-content-center justify-content-xl-start" data-ani="slideinup" data-ani-delay="0.9s">';
													if(!empty($data['button_text'])){
														echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn2 style2"><span>'.esc_html($data['button_text']).'</span><span class="icon"><i class="fa-solid fa-caret-right"></i></span></a>';
													}
													if(!empty($data['button_text2'])){
														echo '<a href="'.esc_url( $data['button_url2']['url'] ).'" class="th-btn2 th-border th_btn">'.esc_html($data['button_text2']).'</a>';
													}
												echo '</div>';
												echo '<div class="hero-client-box mb-sm-0 mb-5" data-ani="slideinup" data-ani-delay="0.8s">';
													echo '<div class="client-thumb-group">';
														if(!empty($data['image2']['url'])){
															echo '<div class="thumb">';
																echo webteck_img_tag( array(
																	'url'   => esc_url( $data['image2']['url'] ),
																)); 
															echo '</div>';
														}
													echo '</div>';
													if(!empty($data['title2'])){
														echo '<h4 class="cilent-box_counter">'.wp_kses_post($data['title2']).'</h4>';
													}
												echo '</div>';
											echo '</div>';
										echo '</div>';
										echo '<div class="col-xl-6">';
											if(!empty($data['image']['url'])){
												echo '<div class="th-hero-img" data-ani="slideinup" data-ani-delay="0.10s">';
													echo webteck_img_tag( array(
														'url'   => esc_url( $data['image']['url'] ),
													)); 
												echo '</div>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
					echo '</div>';
					echo '<div class="slider-controller">';
						echo '<div class="icon-box">';
							echo '<button data-slider-prev="#heroSlide23" class="slider-arrow default slider-prev"><i class="fa-sharp fa-solid fa-caret-left"></i></button>';
							echo '<button data-slider-next="#heroSlide23" class="slider-arrow default slider-next"><i class="fa-sharp fa-solid fa-caret-right"></i></button>';
						echo '</div>';
						echo '<div class="slider-pagination" data-slider-id="#heroSlide23"></div>';
						echo '<div class="slider-pagination2"></div>';
					echo '</div>';
				echo '</div>';
				echo '<div class="hero-counter_wrapp">';
					foreach( $settings['banner_counter'] as $data ){
						echo '<div class="hero-counter">';
							if(!empty($data['counter_title'])){
								echo '<h2 class="counter-title mb-0">'.wp_kses_post($data['counter_title']).'</h2>';
							}
							if(!empty($data['counter_desc'])){
								echo '<span class="hero-counter_text">'.wp_kses_post($data['counter_desc']).'</span>';
							}
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}


	}
}