<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class Traga_Banner_v3 extends Widget_Base {

	public function get_name() {
		return 'tragabannerv3';
	}

	public function get_title() {
		return __( 'Banner Hero', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Banner_section',
			[
				'label' 	=> __( 'Banner', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Banner Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2' 		=> __( 'Style Two', 'webteck' ),
					'3' 		=> __( 'Style Three', 'webteck' ),
					'4' 		=> __( 'Style Four', 'webteck' ),
					'5' 		=> __( 'Style Five', 'webteck' ),
					'6' 		=> __( 'Style Six', 'webteck' ),
					'7' 		=> __( 'Style Seven', 'webteck' ),
					'8' 		=> __( 'Style Eight', 'webteck' ),
					'9' 		=> __( 'Style Nine', 'webteck' ),
					'10' 		=> __( 'Style Ten', 'webteck' ),
				],
			]
		);

		/*----------------------------------------- style one ------------------------------------*/
        $this->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image 1', 'webteck' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $this->add_control(
            'banner_img2',
            [
                'label'     => __( 'Banner Image 2', 'webteck' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );
        $this->add_control(
            'banner_img3',
            [
                'label'     => __( 'Banner Image 3', 'webteck' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> ['layout_style' => ['6', '10']]
            ]
        );
        $this->add_control(
            'heading_icon',
            [
                'label'     => __( 'Heading Icon', 'webteck' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> ['layout_style' => ['7', '8']]
            ]
        );
		$this->add_control(
			'heading', [
				'label' 		=> __( 'Heading', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SECURE & IT SERVICES' , 'webteck' ),
				'label_block' 	=> true,
			]
        );
        $this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SECURE & IT SERVICES' , 'webteck' ),
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['2','5', '6', '7', '8', '9', '10']]
			]
        );
        $this->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Energistically harness ubiquitous imperatives without state of the art collaboration and idea-sharing. Monotonectally parallel task cross-unit experiences and front-end.' , 'webteck' ),
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['1','2','3','4', '6', '8', '9', '10']]
			]
        );
        $this->add_control(
			'button_text_1',
			[
				'label' 	=> esc_html__( 'Button Text', 'webteck' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'DISCOBER MORE', 'webteck' ),
                'condition'	=> ['layout_style' => ['1','3','4','5', '6', '7', '8', '9', '10']]
			]
        );

        $this->add_control(
			'button_link_1',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['layout_style' => ['1','3','4','5', '6', '7', '8', '9', '10']]
			]
		);
		$this->add_control(
			'button_text_2',
			[
				'label' 	=> esc_html__( 'Second Button Text', 'webteck' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'CONTACT US', 'webteck' ),
                'condition'	=> ['layout_style' => ['1','3','5', '6', '8', '10']]
			]
        );

        $this->add_control(
			'button_link_2',
			[
				'label' 		=> esc_html__( 'Second Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['layout_style' => ['1','3','5', '6', '8', '10']]
			]
		);

		$this->add_control(
			'client_rating',
			[
				'label' 	=> __( 'Client Rating', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '5',
				'options' 	=> [
					'one'  		=> __( 'One Star', 'webteck' ),
					'two' 		=> __( 'Two Star', 'webteck' ),
					'three' 	=> __( 'Three Star', 'webteck' ),
					'four' 		=> __( 'Four Star', 'webteck' ),
					'five' 	 	=> __( 'Five Star', 'webteck' ),
				],
				'condition'	=> ['layout_style' => ['5']]
			]
		);
		$this->add_control(
			'ratting_text',
			[
				'label' 	=> esc_html__( 'Ratting Text', 'webteck' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'CONTACT US', 'webteck' ),
                'condition'	=> ['layout_style' => ['5']]
			]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'client_logo',
			[
				'label' 	=> __( 'Brand Logo', 'webteck' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'logos',
			[
				'label' 		=> __( 'Brand Logos', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
				],
				'condition'	=> ['layout_style' => ['5', '8']]
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'image_lists',
			[
				'label' 		=> __( 'Image Lists', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> ['layout_style' => ['7']]
			]
		);
		$this->add_control(
			'rating_title',
			[
				'label' 	=> __( 'Rating Title', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Title', 'webteck' ),
                'condition'	=> ['layout_style' => ['7']]
			]
        );
        $this->add_control(
			'rating',
			[
				'label' 	=> __( 'Rating', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '', 'webteck' ),
                'condition'	=> ['layout_style' => ['7']]
			]
        );
		
		$fields_to_include = [ 'title' => ['Number', 'After Prefix'], 'desc' => ['Description'], ];
		webteck_repeater_fields( $this, 'counter_lists', 'Counter List', $fields_to_include, ['7'] );

		$this->add_control(
			'show_shape',
			[
				'label' 		=> __( 'Show Shape ?', 'webteck' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'webteck' ),
				'label_off' 	=> __( 'Hide', 'webteck' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [ 'layout_style' => [ '6', '7', '8', '9', '10' ] ],
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'Banner_section2',
			[
				'label' 	=> __( 'Box Content', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition'		=> [ 'layout_style' => [ '9' ] ],
			]
        );

		$this->add_control(
			'box1_show',
			[
				'label' 		=> __( 'Show Box 1?', 'webteck' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'webteck' ),
				'label_off' 	=> __( 'Hide', 'webteck' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->add_control(
			'box_title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SECURE & IT SERVICES' , 'webteck' ),
			]
        );
        $this->add_control(
			'box_desc', [
				'label' 		=> __( 'Box Description', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SECURE & IT SERVICES' , 'webteck' ),
			]
        );

		$repeater = new Repeater();

        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'box_img_lists',
			[
				'label' 		=> __( 'Image Lists', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
			]
		);

		$this->add_control(
			'box2_show',
			[
				'label' 		=> __( 'Show Box 2?', 'webteck' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'webteck' ),
				'label_off' 	=> __( 'Hide', 'webteck' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
            'box_img2',
            [
                'label'     => __( 'Box Image', 'webteck' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
            ]
        );
        $this->add_control(
			'box_title2', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SECURE & IT SERVICES' , 'webteck' ),
			]
        );
        $this->add_control(
			'box_desc2', [
				'label' 		=> __( 'Box Description', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SECURE & IT SERVICES' , 'webteck' ),
			]
        );

		$this->end_controls_section();


       	//---------------------------------------
			//Style Section Start
		//---------------------------------------
		webteck_common_style_fields($this, 'sub', 'Subtitle', '{{WRAPPER}} .th-head');
		webteck_common_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .hero-title', ['2', '5', '6', '7', '8', '9', '10'] );
		webteck_common_style_fields($this, 'desc2', 'Description', '{{WRAPPER}} .hero-text', ['1', '2', '3', '4', '5', '6', '8', '9', '10'] );

		//---------------------------------------Button Style---------------------------------------//
		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['layout_style' => ['1','4']]
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'webteck' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'color: {{VALUE}}',
					'{{WRAPPER}} .play-btn > i' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'webteck' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .play-btn:hover > i' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'webteck' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' 		=> 'background-color:{{VALUE}}',
					'{{WRAPPER}} .play-btn > i' => 'background-color:{{VALUE}}',
					'{{WRAPPER}} .play-btn:before , {{WRAPPER}} .play-btn:after' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color',
			[
				'label' 		=> __( 'Button Background Hover Color', 'webteck' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:before, {{WRAPPER}} .th-btn:after' => 'background-color:{{VALUE}}',
					'{{WRAPPER}} .play-btn:hover > i' => 'background-color:{{VALUE}}',
					'{{WRAPPER}} .play-btn:hover:before , {{WRAPPER}} .play-btn:hover:after' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'webteck' ),
                'selector' 	=> '{{WRAPPER}} .btn2',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border_hover',
				'label' 	=> __( 'Border Hover', 'webteck' ),
                'selector' 	=> '{{WRAPPER}} .btn2:hover',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'webteck' ),
                'selector' 	=> '{{WRAPPER}} .btn2',
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'webteck' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'webteck' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->end_controls_section();


		//------Button Style-------
		webteck_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th_btn', ['6', '7', '8', '9', '10'] );
		webteck_button_style_fields( $this, '13', 'Button Styling', '{{WRAPPER}} .th_btn2', ['8', '10'] );

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="th-hero-wrapper hero-7" id="hero">';
		        echo '<div class="hero-inner">';
		        	if(!empty($settings['banner_img']['url'])){
			            echo '<div class="th-hero-bg" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
			        }
		            echo '</div>';
		            echo '<div class="container th-container4">';
		                echo '<div class="row justify-content-center">';
		                    echo '<div class="col-lg-8">';
		                        echo '<div class="hero-style7 text-center">';
		                        	if(!empty($settings['heading'])){
			                            echo '<h1 class="hero-title th-head">'.wp_kses_post($settings['heading']).'</h1>';
			                        }
			                        if(!empty($settings['banner_desc'])){
			                            echo '<p class="hero-text">'.esc_html($settings['banner_desc']).'</p>';
			                        }
		                            echo '<div class="btn-group mt-35 justify-content-center">';
		                            	if(!empty($settings['button_text_1'])){
				                            echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style-radius">'.esc_html($settings['button_text_1']).'</a>';
				                        }
				                        if(!empty($settings['button_text_2'])){
				                            echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="th-btn style6 style-radius">'.esc_html($settings['button_text_2']).'</a>';
				                        }
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		                if(!empty($settings['banner_img2']['url'])){
			                echo '<div class="th-hero-thumb">';
			                    echo '<img src="'.esc_url($settings['banner_img2']['url']).'" alt="img">';
			                echo '</div>';
			            }
		            echo '</div>';
		       echo ' </div>';
		    echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="th-hero-wrapper hero-8" id="hero">';
		        echo '<div class="hero-inner">';
		        	if(!empty($settings['banner_img']['url'])){
			            echo '<div class="th-hero-bg" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
			        }
		            echo '</div>';
		            echo '<div class="container th-container4">';
		                echo '<div class="row justify-content-center align-items-center">';
		                    echo '<div class="col-xxl-5 col-xl-6">';
		                        echo '<div class="hero-style8">';
		                        	if(!empty($settings['heading'])){
			                            echo '<span class="sub-title th-head">'.wp_kses_post($settings['heading']).'</span>';
			                        }
			                        if(!empty($settings['title'])){
			                            echo '<h1 class="hero-title">'.wp_kses_post($settings['title']).'</h1>';
			                        }
			                        if(!empty($settings['banner_desc'])){
			                            echo '<p class="hero-text">'.wp_kses_post($settings['banner_desc']).'</p>';
			                        }
		                            echo '<div class="btn-group mt-30">';
		                            	if(!empty($settings['button_link_1']['url'])){
			                                echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style7 style-radius"><img src="'.WEBTECK_PLUGDIRURI.'assets/img/play-store-btn.png" alt="img"></a>';
			                            }
			                            if(!empty($settings['button_link_2']['url'])){
			                                echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="th-btn style7 style-radius"><img src="'.WEBTECK_PLUGDIRURI.'assets/img/apple-btn.png" alt="img"></a>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                    echo '<div class="col-xxl-7 col-xl-6">';
		                    	if(!empty($settings['banner_img2']['url'])){
			                        echo '<div class="th-hero-thumb">';
			                            echo '<img src="'.esc_url($settings['banner_img2']['url']).'" alt="img">';
			                        echo '</div>';
			                    }
		                   echo ' </div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="th-hero-wrapper hero-10" id="hero">';
		        echo '<div class="container th-container4">';
		            echo '<div class="row align-items-end">';
		                echo '<div class="col-xl-7">';
		                    echo '<div class="hero-style10">';
		                    	if(!empty($settings['heading'])){
			                        echo '<h1 class="hero-title th-head">'.wp_kses_post($settings['heading']).'</h1>';
			                    }
			                    if(!empty($settings['banner_desc'])){
			                        echo '<p class="hero-text">'.wp_kses_post($settings['banner_desc']).'</p>';
			                    }
		                        echo '<div class="btn-group">';
		                        	if(!empty($settings['button_link_1']['url'])){
			                            echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style8">'.esc_html($settings['button_text_1']).'</a>';
			                        }
			                        if(!empty($settings['button_text_2'])){
			                            echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="th-btn style5 style8">'.esc_html($settings['button_text_2']).'</a>';
			                        }
		                        echo '</div>';
		                    echo '</div>';

		                echo '</div>';
		                echo '<div class="col-xl-5">';
		                    echo '<div class="th-hero-img">';
		                    	if(!empty($settings['banner_img']['url'])){
			                        echo '<img src="'.esc_url($settings['banner_img']['url']).'" alt="">';
			                        echo '<div class="hero-line1"></div>';
			                        echo '<div class="hero-line2"></div>';
			                    }
			                    if(!empty($settings['banner_img2']['url'])){
			                        echo '<div class="hero10-shape">';
			                            echo '<img src="'.esc_url($settings['banner_img2']['url']).'" alt="">';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';

		    echo '</div>';

		}elseif( $settings['layout_style'] == '4' ){
			echo '<div class="th-hero-wrapper hero-9" id="hero" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
		        echo '<div class="container th-container4">';
		            echo '<div class="row align-items-end">';
		                echo '<div class="col-xl-6">';
		                    echo '<div class="hero-style9">';
		                    	if(!empty($settings['heading'])){
			                        echo '<h1 class="hero-title th-head">'.wp_kses_post($settings['heading']).'</h1>';
			                    }
			                    if(!empty($settings['banner_desc'])){
			                        echo '<p class="hero-text">'.esc_html($settings['banner_desc']).'</p>';
			                    }
			                    if(!empty($settings['button_text_1'])){
			                        echo '<div class="btn-group">';
			                            echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn btn-gradient style-radius">'.esc_html($settings['button_text_1']).'</a>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		                if(!empty($settings['banner_img2']['url'])){
			                echo '<div class="col-xl-6">';
			                    echo '<div class="th-hero-img">';
			                        echo '<img src="'.esc_url($settings['banner_img2']['url']).'" alt="">';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="th-hero-wrapper hero-13" id="hero" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
		        echo '<div class="container th-container4">';
		            echo '<div class="row align-items-center">';
		                echo '<div class="col-xl-7">';
		                    echo '<div class="hero-style13">';
		                    	if(!empty($settings['heading'])){
			                        echo '<span class="sub-title th-head">'.wp_kses_post($settings['heading']).'</span>';
			                    }
			                    if(!empty($settings['title'])){
			                        echo '<h1 class="hero-title">'.wp_kses_post($settings['title']).'</h1>';
			                    }
		                        echo '<div class="hero-wrapp">';
		                            echo '<div class="btn-group">';
		                            	if(!empty($settings['button_link_1']['url'])){
			                                echo '<div class="">';
			                                    echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style3 text-capitalize">'.esc_html($settings['button_text_1']).'</a>';
			                                echo '</div>';
			                            }
			                            if(!empty($settings['button_link_2']['url'])){
			                                echo '<div class="call-btn">';
			                                    echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
			                                    echo '<div class="media-body">';
			                                        echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="btn-title popup-video">'.esc_html($settings['button_text_2']).'</a>';
			                                    echo '</div>';
			                                echo '</div>';
			                            }

		                            echo '</div>';
		                            echo '<div class="cilent-box">';
		                                echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/arrow.png" alt="">';
		                                echo '<div class="about-content">';
		                                	if(!empty($settings['ratting_text'])){
			                                    echo '<span class="title">'.esc_html($settings['ratting_text']).'</span>';
			                                }
		                                    echo '<div class="about-wrapp">';
		                                        echo '<div class="about_review">';
		                                            if( $settings['client_rating'] == 'one' ){
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
													}elseif( $settings['client_rating'] == 'two' ){
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
													}elseif( $settings['client_rating'] == 'three' ){
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
													}elseif( $settings['client_rating'] == 'four' ){
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-light fa-star-sharp"></i>';
													}else{
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
														echo '<i class="fa-solid fa-star-sharp"></i>';
													}
		                                            
		                                        echo '</div>';
		                                    echo '</div>';
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		                if(!empty($settings['banner_img2']['url'])){
			                echo '<div class="col-xl-5">';
			                    echo '<div class="th-hero-img">';
			                        echo '<img src="'.esc_url($settings['banner_img2']['url']).'" alt="">';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="slider-area text-center">';
		            echo '<div class="swiper th-slider brand-slider7" id="brandSlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"4"}}}\'>';
		                echo '<div class="swiper-wrapper">';

		                	foreach( $settings['logos'] as $singlelogo ) {
			                    echo '<div class="swiper-slide">';
			                        echo '<div class="brand-box">';
			                            echo '<img src="'.esc_url( $singlelogo['client_logo']['url'] ).'" alt="Brand Logo">';
			                        echo '</div>';
			                    echo '</div>';
			                }
		                    

		                echo '</div>';

		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="th-hero-wrapper hero-14" id="hero">';
				echo '<div class="hero-inner">';
					echo '<div class="th-hero-bg" data-bg-src="'.esc_url($settings['banner_img']['url']).'"></div>';
					echo '<div class="container th-container4">';
						echo '<div class="row justify-content-center align-items-center">';
							echo '<div class="col-xxl-7 col-xl-6">';
								echo '<div class="hero-style14">';
									if(!empty($settings['heading'])){
										echo '<span class="sub-title th-head">'.wp_kses_post($settings['heading']).'</span>';
									}
									if(!empty($settings['title'])){
										echo '<h1 class="hero-title">'.wp_kses_post($settings['title']).'</h1>';
									}
									if(!empty($settings['banner_desc'])){
										echo '<p class="hero-text">'.esc_html($settings['banner_desc']).'</p>';
									}
									echo '<div class="btn-group">';
										if(!empty($settings['button_link_1']['url'])){
											echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style-radius text-capitalize th_btn">'.esc_html($settings['button_text_1']).'</a>';
										}
										if(!empty($settings['button_link_2']['url'])){
			                                echo '<div class="call-btn">';
			                                    echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
			                                    echo '<div class="media-body">';
			                                        echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="btn-title popup-video">'.esc_html($settings['button_text_2']).'</a>';
			                                    echo '</div>';
			                                echo '</div>';
			                            }
									echo '</div>';
								echo '</div>';
							echo '</div>';
							echo '<div class="col-xxl-5 col-xl-6">';
								echo '<div class="th-hero-image">';
									if (!empty($settings['banner_img2']['url'])) {
										echo '<div class="th-hero-thumb">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $settings['banner_img2']['url']  ),
											));
										echo '</div>';
									}
									if (!empty($settings['banner_img3']['url'])) {
										echo '<div class="th-hero-thumb2 jump">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $settings['banner_img3']['url']  ),
											));
										echo '</div>';
									}
									if ($settings['show_shape'] == 'yes' ) {
										echo '<div class="hero-shape movingX">';
											echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero-shape2.png" alt="'.esc_attr__('Shape', 'webteck').'">';
										echo '</div>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
				if ($settings['show_shape'] == 'yes' ) {
					echo '<div class="shape-mockup spin d-none d-xl-block" data-top="20%" data-left="33%">';
						echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/shape_2.png" alt="'.esc_attr__('Shape', 'webteck').'">';
					echo '</div>';
					echo '<div class="shape-mockup movingX d-none d-xl-block" data-bottom="6%" data-left="28%">';
						echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/shape_3.png" alt="'.esc_attr__('Shape', 'webteck').'">';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '7' ){
			echo '<div class="th-hero-wrapper hero-16" id="hero" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
				echo '<div class="hero-inner">';
					echo '<div class="container th-container4">';
						echo '<div class="row justify-content-center align-items-center">';
							echo '<div class="col-xl-6">';
								echo '<div class="hero-style16">';
									if(!empty($settings['heading'])){
									echo '<span class="sub-title th-head">';
										if (!empty($settings['heading_icon']['url'])) {
											echo '<div class="icon-masking me-2">';
												echo webteck_img_tag( array(
													'url'   => esc_url( $settings['heading_icon']['url']  ),
												));
											echo '</div>';
										}
										echo wp_kses_post($settings['heading']);
									echo '</span>';
									}
									if(!empty($settings['title'])){
										echo '<h1 class="hero-title">'.wp_kses_post($settings['title']).'</h1>';
									}
									echo '<div class="btn-group">';
										if(!empty($settings['button_link_1']['url'])){
											echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style-radius text-capitalize th_btn">'.esc_html($settings['button_text_1']).'</a>';
										}
										echo '<div class="about-client-box style2 mb-sm-0 mb-3">';
											echo '<div class="client-thumb-group">';
												foreach( $settings['image_lists'] as $data ) {  
													if(!empty($data['image']['url'])){
														echo '<div class="thumb">';
															echo webteck_img_tag( array(
																'url'   => esc_url( $data['image']['url']  ),
															));
														echo '</div>';
													}
												}
											echo '</div>';
											echo '<div class="cilent-box">';
												if( !empty( $settings['rating'] ) ){
													echo '<div class="about_review">'.wp_kses_post($settings['rating']).'</div>';
												}
												if( !empty( $settings['rating_title'] ) ){
													echo '<h4 class="cilent-box_counter">'.wp_kses_post($settings['rating_title']).'</h4>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';

									echo '<div class="hero-counter_wrapp">';
									foreach( $settings['counter_lists'] as $data ){
										echo '<div class="hero-counter">';
											if(!empty($data['number'])){
												echo '<h2 class="counter-title mb-0"><span class="counter-number">'.wp_kses_post( $data['number'] ).'</span>'.wp_kses_post( $data['after_prefix'] ).'</h2>';
											}
											if(!empty($data['description'])){
												echo '<span class="hero-counter_text">'.wp_kses_post( $data['description'] ).'</span>';
											}
										echo '</div>';
									}
									echo '</div>';

								echo '</div>';
							echo '</div>';
							echo '<div class="col-xl-6">';
								if (!empty($settings['banner_img2']['url'])) {
									echo '<div class="th-hero-image">';
										echo '<div class="th-hero-thumb">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $settings['banner_img2']['url']  ),
											));
										echo '</div>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
				if ($settings['show_shape'] == 'yes' ) {
				echo '<div class="shape-mockup d-none d-xl-block" data-bottom="8%" data-left="4%">';
					echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/shape_7.png" alt="'.esc_attr__('Shape', 'webteck').'">';
				echo '</div>';
				echo '<div class="shape-mockup movingX d-none d-xl-block" data-top="54%" data-right="44%">';
					echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/shape_8.png" alt="'.esc_attr__('Shape', 'webteck').'">';
				echo '</div>';
				echo '<div class="shape-mockup spin d-none d-xl-block" data-bottom="14%" data-right="6%">';
					echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/shape_9.png" alt="'.esc_attr__('Shape', 'webteck').'">';
				echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '8' ){
			echo '<div class="th-hero-wrapper hero-15" id="hero" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
				echo '<div class="hero-inner">';
					echo '<div class="container th-container4">';
						echo '<div class="row">';
							echo '<div class="col-xl-7">';
								echo '<div class="hero-style15">';
									if(!empty($settings['heading'])){
										echo '<span class="sub-title th-head">';
											if (!empty($settings['heading_icon']['url'])) {
												echo '<div class="icon-masking me-2">';
													echo '<span class="mask-icon" data-mask-src="'.esc_url( $settings['heading_icon']['url'] ).'"></span>';
													echo webteck_img_tag( array(
														'url'   => esc_url( $settings['heading_icon']['url'] ),
													));
												echo '</div>';
											}
											echo wp_kses_post($settings['heading']);
										echo '</span>';
									}
									if(!empty($settings['title'])){
										echo '<h1 class="hero-title">'.wp_kses_post($settings['title']).'</h1>';
									}
									if(!empty($settings['banner_desc'])){
										echo '<p class="hero-text">'.esc_html($settings['banner_desc']).'</p>';
									}
									echo '<div class="btn-group">';
										if(!empty($settings['button_text_1'])){
											echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style-radius text-capitalize th_btn">'.esc_html($settings['button_text_1']).'</a>';
										}
										if(!empty($settings['button_text_2'])){
											echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="th-btn style7 style-radius text-capitalize th_btn2">'.esc_html($settings['button_text_2']).'</a>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';

				if (!empty($settings['banner_img2']['url'])) {
					echo '<div class="th-hero15-img">';
						echo '<div class="hero15-img" data-mask-src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero_shape_4.png">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['banner_img2']['url']  ),
						));
						echo '</div>';
						echo '<div class="hero15-shape" data-mask-src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero_shape_4.1.png"></div>';
					echo '</div>';
				}

				echo '<div class="brand-slider8-area">';
					echo '<div class="slider-area text-center">';
						echo '<div class="swiper th-slider brand-slider8" id="brandSlider5" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"5"}}}\'>';
							echo '<div class="swiper-wrapper">';
								foreach( $settings['logos'] as $singlelogo ) {
									if (!empty($singlelogo['client_logo']['url'])) {
										echo '<div class="swiper-slide">';
											echo '<div class="brand-box style3">';
												echo '<img src="'.esc_url( $singlelogo['client_logo']['url'] ).'" alt="'.esc_attr__('Logo', 'webteck').'">';
											echo '</div>';
										echo '</div>';
									}
								}
							echo '</div>';

						echo '</div>';
					echo '</div>';
				echo '</div>';

				if ($settings['show_shape'] == 'yes' ) {
				echo '<div class="shape-mockup movingX d-none d-xl-block" data-bottom="20%" data-left="5%">';
					echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/shape_4.png" alt="'.esc_attr__('Shape', 'webteck').'">';
				echo '</div>';
				echo '<div class="shape-mockup jump d-none d-xl-block" data-bottom="14%" data-left="45%">';
					echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/shape_5.png" alt="'.esc_attr__('Shape', 'webteck').'">';
				echo '</div>';
				echo '<div class="shape-mockup z-index-3 d-none d-xxl-block" data-top="40%" data-right="34%">';
					echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/shape_6.png" alt="'.esc_attr__('Shape', 'webteck').'">';
				echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '9' ){
			echo '<div class="th-hero-wrapper hero-17" id="hero" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
				echo '<div class="container th-container4">';
					echo '<div class="row align-items-center">';
						echo '<div class="col-xl-7">';
							echo '<div class="hero-style17">';
								if(!empty($settings['heading'])){
									echo '<span class="sub-title th-head">'.wp_kses_post($settings['heading']).'</span>';
								}
								if(!empty($settings['title'])){
									echo '<h1 class="hero-title">'.wp_kses_post($settings['title']).'</h1>';
								}
								if(!empty($settings['banner_desc'])){
									echo '<p class="hero-text">'.esc_html($settings['banner_desc']).'</p>';
								}
								if(!empty($settings['button_text_1'])){
									echo '<div class="btn-group">';
										echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style-radius text-capitalize th_btn">'.esc_html($settings['button_text_1']).'</a>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
						echo '<div class="col-xl-5">';
							echo '<div class="th-hero17-wrapp">';
								if (!empty($settings['banner_img2']['url'])) {
									echo '<div class="th-hero-img">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $settings['banner_img2']['url']  ),
										));
									echo '</div>';
								}
								if ($settings['show_shape'] == 'yes' ) {
								echo '<div class="hero17-shape1" data-mask-src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero17-shape1.png"></div>';
								echo '<div class="hero17-shape2" data-mask-src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero17-shape2.png"></div>';
								echo '<div class="hero17-shape3">';
									echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero-line.png" alt="'.esc_attr__('Shape', 'webteck').'">';
								echo '</div>';
								}
								if ($settings['box1_show'] == 'yes' ) {
								echo '<div class="hero-client-box movingX mb-sm-0 mb-5">';
									if(!empty($settings['box_title'])){
										echo '<h4 class="cilent-box_counter">'.wp_kses_post($settings['box_title']).'</h4>';
									}
									if(!empty($settings['box_desc'])){
										echo '<span class="cilent-box_title">'.esc_html($settings['box_desc']).'</span>';
									}
									echo '<div class="client-thumb-group">';
										foreach( $settings['box_img_lists'] as $data ) {  
											if(!empty($data['image']['url'])){
												echo '<div class="thumb">';
													echo webteck_img_tag( array(
														'url'   => esc_url( $data['image']['url']  ),
													));
												echo '</div>';
											}
										}
										echo '<div class="thumb icon"><i class="fa-regular fa-plus"></i></div>';
									echo '</div>';
								echo '</div>';
								}
								if ($settings['box2_show'] == 'yes' ) {
								echo '<div class="hero-profile">';
									if (!empty($settings['box_img2']['url'])) {
										echo '<div class="avater">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $settings['box_img2']['url']  ),
											));
										echo '</div>';
									}
									echo '<div class="media-body">';
										if(!empty($settings['box_title2'])){
											echo '<h3 class="box-title">'.wp_kses_post($settings['box_title2']).'</h3>';
										}
										if(!empty($settings['box_desc2'])){
											echo '<span class="desig">'.esc_html($settings['box_desc2']).'</span>';
										}
									echo '</div>';
								echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '10' ){
			echo '<div class="th-hero-wrapper hero-20" id="hero" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
				echo '<div class="hero20-overlay" data-bg-src="'.esc_url($settings['banner_img2']['url']).'"></div>';
				echo '<div class="container th-container4">';
					echo '<div class="row align-items-end">';
						echo '<div class="col-xl-7">';
							echo '<div class="hero-style20">';
								if(!empty($settings['heading'])){
									echo '<span class="sub-title sub-title5 th-head text-capitalize">'.wp_kses_post($settings['heading']).'</span>';
								}
								if(!empty($settings['title'])){
									echo '<h1 class="hero-title">'.wp_kses_post($settings['title']).'</h1>';
								}
								if(!empty($settings['banner_desc'])){
									echo '<p class="hero-text">'.esc_html($settings['banner_desc']).'</p>';
								}
								echo '<div class="btn-group justify-content-center justify-content-xl-start">';
									if(!empty($settings['button_text_1'])){
										echo '<a href="'.esc_url( $settings['button_link_1']['url'] ).'" class="th-btn style-radius style3 text-capitalize th_btn">'.esc_html($settings['button_text_1']).'</a>';
									}
									if(!empty($settings['button_text_2'])){
										echo '<a href="'.esc_url( $settings['button_link_2']['url'] ).'" class="th-btn style-radius style2 text-capitalize th_btn2">'.esc_html($settings['button_text_2']).'</a>';
									}
								echo '</div>';
		
							echo '</div>';
						echo '</div>';
						if (!empty($settings['banner_img2']['url'])) {
							echo '<div class="col-xl-5">';
								echo '<div class="th-hero-img">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $settings['banner_img3']['url']  ),
									));
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				if ($settings['show_shape'] == 'yes' ) {
					echo '<div class="shape-mockup movingX d-none d-xxl-block" data-bottom="0%" data-left="1%"><img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero20-shape-1.png" alt="'.esc_attr__('Shape', 'webteck').'">
					</div>
					<div class="shape-mockup movingX d-none d-xxl-block" data-top="3%" data-left="35%"><img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero20-shape-2.png" alt="'.esc_attr__('Shape', 'webteck').'">
					</div>
					<div class="shape-mockup movingX d-none d-xxl-block" data-bottom="14%" data-left="45%"><img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero20-shape-3.png" alt="'.esc_attr__('Shape', 'webteck').'">
					</div>
					<div class="shape-mockup movingX d-none d-xxl-block" data-bottom="18%" data-right="5%"><img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/hero20-shape-4.png" alt="'.esc_attr__('Shape', 'webteck').'">
					</div>';
				}
			echo '</div>';

		}


	}

}