<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Form Box Widget .
 *
 */
class Webteck_Contact_Form extends Widget_Base {

	public function get_name() {
		return 'webteckcontactform';
	}
	public function get_title() {
		return __( 'Contact Form', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'webteck' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'webteck' ) ] = 0;
        }
        return $as_cfa;
    }

	protected function register_controls() {

		$this->start_controls_section(
			'teamd_section',
			[
				'label' 	=> __( 'Contact Form', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Contact Form Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'webteck' ),
					'layout_two'  		=> __( 'Style Two', 'webteck' ),
					'layout_three'  	=> __( 'Style Three', 'webteck' ),
					'layout_four'  		=> __( 'Style Four', 'webteck' ),
					'layout_five'  		=> __( 'Style Five', 'webteck' ),
					'layout_six'  		=> __( 'Style Six', 'webteck' ),
				]
			]
		);
		$this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_one', 'layout_three']]
			]
		);

		webteck_media_fields( $this, 'bg', 'Choose Background', ['layout_five'] );

		$this->add_control(
		    'webteck_select_contact_form',
		    [
		        'label'   => esc_html__( 'Select Form', 'webteck' ),
		        'type'    => \Elementor\Controls_Manager::SELECT,
		        'default' => '0',
		        'options' => $this->get_as_contact_form(),
		    ]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'icon',
			[
				'label'     => __( 'Icon', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '', 'webteck' )
			]
        );
		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Title Area', 'webteck' )
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 4,
                'default'  	=> __( 'Content Area', 'webteck' )
			]
        );
        
        $this->add_control(
			'features',
			[
				'label' 		=> __( 'Contact Info', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> ['layout_style' => ['layout_two']]
			]
		);

		$this->add_control(
			'video_title', [
				'label' 		=> __( 'Video Circle Text', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'condition'		=> [ 'layout_style' => [ 'layout_six' ] ],
			]
		);
		$this->add_control(
			'video_link',
			[
				'label' 		=> __( 'Video Url', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
                'placeholder' 	=> __( 'https://your-link.com', 'webteck' ),
                'show_external' => true,
				'default' 		=> [
					'url' 			=> 'https://www.youtube.com/watch?v=_sI_Ps7JSEk',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
				'condition'		=> [ 'layout_style' => [ 'layout_six' ] ],
			]
        );

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------
		webteck_common_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .title', ['layout_one', 'layout_three'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
            if( !empty($settings['webteck_select_contact_form']) ){
            	echo '<div class="appointment-area-wrapp">';
					if( ! empty( $settings['title']) ){
						echo '<h6 class="title">'.esc_html( $settings['title'] ).'</h6>';
					}
					echo do_shortcode( '[contact-form-7  id="'.$settings['webteck_select_contact_form'].'"]' ); 
				echo '</div>';
			}else{
				echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'webteck' ). '</p></div>';
			}

	    }elseif( $settings['layout_style'] == 'layout_two' ){
			echo '<div class="row gy-4 justify-content-center">';
				echo '<div class="col-xl-9">';
					echo '<div class="contact-form2 ajax-contact">';
						if( !empty($settings['webteck_select_contact_form']) ){
							echo do_shortcode( '[contact-form-7  id="'.$settings['webteck_select_contact_form'].'"]' ); 
						}else{
							echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'kitar' ). '</p></div>';
						}
					echo '</div>';
				echo '</div>';
				echo '<div class="col-xl-3">';
					echo '<div class="contact-item-wrap">';
						foreach( $settings['features'] as $data ) {
							echo '<div class="contact-item">';
								if (!empty($data['icon'])) {
									echo '<div class="contact-item_icon">';
										echo wp_kses_post( $data['icon'] );
									echo '</div>';
								}
								echo '<div class="media-body">';
									if (!empty($data['title'])) {
										echo '<p class="contact-item_label">'.esc_html( $data['title'] ).'</p>';
									}
									if (!empty($data['content'])) {
										echo '<div>'.wp_kses_post( $data['content'] ).'</div>';
									}
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_three' ){
			echo '<div class="appointment-area-wrapp">';
				if( ! empty( $settings['title']) ){
					echo '<h6 class="title">'.esc_html( $settings['title'] ).'</h6>';
				}
				echo '<div class="appointment-form3 input-smoke ajax-contact">';
					if( !empty($settings['webteck_select_contact_form']) ){
						echo do_shortcode( '[contact-form-7  id="'.$settings['webteck_select_contact_form'].'"]' ); 
					}else{
						echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'kitar' ). '</p></div>';
					}
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_four' ){
			echo '<div class="contact-form2 style2 ajax-contact">';
				if( !empty($settings['webteck_select_contact_form']) ){
					echo do_shortcode( '[contact-form-7  id="'.$settings['webteck_select_contact_form'].'"]' ); 
				}else{
					echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'kitar' ). '</p></div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_five' ){
			echo '<div class="contact-form3 ajax-contact" data-bg-src="'.esc_url($settings['bg']['url']).'">';
				if( !empty($settings['webteck_select_contact_form']) ){
					echo do_shortcode( '[contact-form-7  id="'.$settings['webteck_select_contact_form'].'"]' ); 
				}else{
					echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'kitar' ). '</p></div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_six' ){
			if( !empty( $settings['video_link']['url'] ) ) {
				echo '<div class="discount-wrapp2 text-end mb-60">';
					echo '<a href="'.esc_url($settings['video_link']['url']).'" class="play-btn popup-video">';
						echo '<i class="fa-solid fa-play"></i></a>';
					if( ! empty( $settings['video_title']) ){
						echo '<div class="discount-tag">';
							echo '<span class="discount-anime">'.esc_html( $settings['video_title'] ).'</span>';
						echo '</div>';
					}
				echo '</div>';
			}

			echo '<div class="contact-form4 ajax-contact">';
				if( !empty($settings['webteck_select_contact_form']) ){
					echo do_shortcode( '[contact-form-7  id="'.$settings['webteck_select_contact_form'].'"]' ); 
				}else{
					echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'kitar' ). '</p></div>';
				}
			echo '</div>';

		}


	}
}