<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Counter Up Box Widget .
 *
 */
class Webteck_Counter_Up extends Widget_Base {

	public function get_name() {
		return 'webteckcounterup';
	}

	public function get_title() {
		return __( 'Counter Up', 'webteck' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'webteck' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'counterupd_section',
			[
				'label' 	=> __( 'Counter Up', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Counter Up Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'webteck' ),
					'layout_two'  		=> __( 'Style Two', 'webteck' ),
					'layout_three'  	=> __( 'Style Three', 'webteck' ),
					'layout_four'  		=> __( 'Style Four', 'webteck' ),
					'layout_five'  		=> __( 'Style Five', 'webteck' ),
					'layout_six'  		=> __( 'Style Six', 'webteck' ),
					'layout_seven'  	=> __( 'Style Seven', 'webteck' ),
					'layout_eight'  	=> __( 'Style Eight', 'webteck' ),
					'layout_nine'  		=> __( 'Style Nine', 'webteck' ),
					'layout_ten'  		=> __( 'Style Ten', 'webteck' ),
				]
			]
		);

		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'		=> [ 'layout_style' =>  ['layout_six'] ],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'counter_text', [
				'label' 		=> __( 'Title', 'konsal' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Return on investment' , 'konsal' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'counter_suffix', [
				'label' 		=> __( 'After Title', 'konsal' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> __( 'X' , 'konsal' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'counter_number', [
				'label' 		=> __( 'Number', 'konsal' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> __( '20' , 'konsal' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'desc', [
				'label' 		=> __( 'Short Description', 'konsal' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Return on investment is a financial metric that measures' , 'konsal' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' 		=> esc_html__( 'Image', 'konsal' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'counterup',
			[
				'label' 		=> __( 'Counter Up', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ title }}}',
				'condition'	=> [
					'layout_style' => ['layout_one', 'layout_two', 'layout_three', 'layout_four']
				]
			]
		);

		$fields_to_include = [ 'title' => ['Number', 'After Prefix'], 'desc' => ['Description'], ];
		webteck_repeater_fields( $this, 'counter_lists', 'Counter List', $fields_to_include, ['layout_five', 'layout_seven', 'layout_eight', 'layout_nine', 'layout_ten'] );

		$fields_to_include2 = [ 'title' => ['Number', 'After Prefix', 'After Prefix 2'], 'desc' => ['Description', 'Description 2'], ];
		webteck_repeater_fields( $this, 'counter_lists2', 'Counter List', $fields_to_include2, ['layout_six'] );


		$this->add_control(
			'title',
            [
				'label'         => __( 'Title', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'SUCCESS' , 'webteck' ),
				'condition'		=> [ 'layout_style' =>  ['layout_six']  ],
			]
		);

		$this->add_control(
			'desc',
            [
				'label'         => __( 'Description', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( '(4,5/5) Rating Star by Clients' , 'webteck' ),
				'condition'		=> [ 'layout_style' =>  ['layout_six']  ],
			]
		);

		$this->add_control(
			'content',
            [
				'label'         => __( 'Content', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 6,
				'default'       => __( '' , 'webteck' ),
				'condition'		=> [ 'layout_style' =>  ['layout_six']  ],
			]
		);
		$this->add_control(
			'image2',
			[
				'label' 		=> __( 'Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'		=> [ 'layout_style' =>  ['layout_six'] ],
			]
		);
		$this->add_control(
			'image3',
			[
				'label' 		=> __( 'Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'		=> [ 'layout_style' =>  ['layout_six'] ],
			]
		);
		
        $this->end_controls_section();

        //-------------------------------------title styling-------------------------------------//
        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Style', 'webteck' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		webteck_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one','layout_four'], '--title-color' );
		webteck_all_elementor_style($this, 'Title ', '{{WRAPPER}} .title-selector',['layout_three'], 'color' );
		webteck_all_elementor_style($this, 'Number', '{{WRAPPER}} .number-selector',['layout_one','layout_two','layout_four'], '--title-color' );
		webteck_all_elementor_style($this, 'Number ', '{{WRAPPER}} .box-number',['layout_three'], 'color' );
		webteck_all_elementor_style($this, 'Description', '{{WRAPPER}} .desc-selector',['layout_one','layout_two'], '--body-color' );

        $this->end_controls_section();

		//-------Number Style-------
		webteck_common_style_fields($this, 'number', 'Number', '{{WRAPPER}} .num .counter-number', ['layout_five', 'layout_eight'] );
		webteck_common_style_fields($this, 'number2', 'Number Prefix', '{{WRAPPER}} .num', ['layout_five', 'layout_eight'] );
		//-------Title Style-------
		webteck_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .desc', ['layout_five', 'layout_eight'] );

       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
        	echo '<div class="counter-card4-wrap">';
                foreach( $settings['counterup'] as $data ) {
	                echo '<div class="counter-card4">';
	                	if( ! empty( $data['image']['url']  ) ){
		                    echo '<div class="counter-card4_icon">';
		                        echo webteck_img_tag( array(
				                    'url'   => esc_url( $data['image']['url']  ),
				                ));
		                    echo '</div>';
		                }
	                    echo '<div class="media-body">';
	                    	if( ! empty( $data['counter_number'] ) ){
	                    		$counter_suffix =  $data['counter_suffix'] ?  $data['counter_suffix'] : '';
		                        echo '<h3 class="box-number number-selector"><span class="counter-number ">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $counter_suffix ).'</h3>';
		                    }
		                    if( ! empty( $data['counter_text'] ) ){
		                        echo '<h6 class="counter-title title-selector">'.esc_html( $data['counter_text'] ).'</h6>';
		                    }
		                    if( ! empty( $data['desc'] ) ){
		                        echo '<p class="mb-0 desc-selector">'.esc_html( $data['desc'] ).'</p>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	                echo '<div class="divider"></div>';
	            }
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="row">';
                foreach( $settings['counterup'] as $data ) {
	                echo '<div class="col-sm-6 col-xl-3 counter-card-wrap style2">';
	                    echo '<div class="counter-card style2">';
	                    	if( ! empty( $data['image']['url']  ) ){
			                    echo '<div class="box-icon">';
			                        echo webteck_img_tag( array(
					                    'url'   => esc_url( $data['image']['url']  ),
					                ));
			                    echo '</div>';
			                }
	                        echo '<div class="media-body">';
	                        	if( ! empty( $data['counter_number'] ) ){
		                    		$counter_suffix =  $data['counter_suffix'] ?  $data['counter_suffix'] : '';
		                            echo '<h2 class="box-number text-white number-selector"><span class="counter-number">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $counter_suffix ).'</h2>';
		                        }
		                        if( ! empty( $data['desc'] ) ){
		                            echo '<p class="box-text text-white desc-selector">'.esc_html( $data['desc'] ).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_three' ){
	    	echo '<div class="container th-container4">';
	            echo '<div class="counter-area-7">';
	                echo '<div class="row justify-content-md-between justify-content-center">';
	                    foreach( $settings['counterup'] as $data ) {
		                    echo '<div class="col-xl-3 col-md-6">';
		                        echo '<div class="counter-card7">';
		                            echo '<div class="divider"></div>';
		                            if( ! empty( $data['counter_number'] ) ){
		                            	$counter_suffix =  $data['counter_suffix'] ?  $data['counter_suffix'] : '';
			                            echo '<h3 class="box-number"><span class="counter-number number-selector">'.esc_html( $data['counter_number'] ).'</span>'.esc_html( $counter_suffix ).'</h3>';
			                        }
			                        if( ! empty( $data['counter_text'] ) ){
			                            echo '<div class="media-body">';
			                                echo '<p class=" counter-text mb-n2 title-selector">'.wp_kses_post( $data['counter_text'] ).'</span></p>';
			                            echo '</div>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                }
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_four' ){
	    	echo '<div class="skill-circle-wrap">';
                foreach( $settings['counterup'] as $data ) {       
	                echo '<div class="skill-circle">';
	                    echo '<div class="progressbar" data-path-color="#3E66F3">';
	                    	if( ! empty( $data['counter_number'] ) ){
		                        echo '<div class="circle number-selector" data-percent="'.esc_attr( $data['counter_number'] ).'">';
		                            echo '<div class="circle-num"></div>';
		                            if( ! empty( $data['counter_text'] ) ){
			                            echo '<span class="box-text title-selector">'.wp_kses_post( $data['counter_text'] ).'</span>';
			                        }
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_five' ){
			echo '<div class="row justify-content-md-between justify-content-center gy-40">';
				foreach( $settings['counter_lists'] as $data ){
					echo '<div class="col-xl-auto col-sm-6">';
						echo '<div class="counter-card6">';
							if(!empty($data['number'])){
								echo '<h3 class="box-number num"><span class="counter-number">'.wp_kses_post( $data['number'] ).'</span>'.wp_kses_post( $data['after_prefix'] ).'</h3>';
							}
							echo '<div class="media-body">';
								if(!empty($data['description'])){
									echo '<p class="counter-text mb-n2 desc">'.wp_kses_post( $data['description'] ).'</p>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_six' ){
			echo '<div class="row gy-5">';
				if (!empty($settings['image']['url'])) {
				echo '<div class="col-xl-6 col-xxl-7">';
					echo '<div class="img-box18">';
						echo '<div class="img1">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image']['url']  ),
							));
						echo '</div>';
					echo '</div>';
				echo '</div>';
				}
				echo '<div class="col-xl-6 col-xxl-5">';
					echo '<div class="about17-counter-wrapp">';
						echo '<div class="counter-card9-wrap">';
							foreach( $settings['counter_lists2'] as $data ){
								echo '<div class="counter-card9">';
									echo '<div class="media-body">';
										if(!empty($data['number'])){
											echo '<h3 class="box-number"><span class="counter-number">'.wp_kses_post( $data['number'] ).'</span>'.wp_kses_post( $data['after_prefix'] ).'<span class="text-theme">'.wp_kses_post( $data['after_prefix_2'] ).'</span> </h3>';
										}
										if(!empty($data['description'])){
											echo '<h6 class="counter-title desc">'.wp_kses_post( $data['description'] ).'</h6>';
										}
										if(!empty($data['description_2'])){
											echo '<p class="counter-text desc">'.wp_kses_post( $data['description_2'] ).'</p>';
										}
									echo '</div>';
								echo '</div>';
							}
						echo '</div>';
						echo '<div class="about17-client-wrapp">';
							echo '<div class="cilent-box">';
								if (!empty($settings['image2']['url'])) {
									echo webteck_img_tag( array(
										'url'   => esc_url( $settings['image2']['url']  ),
									));
								}
								echo '<div class="about-content">';
									if(!empty($settings['title'])){
										echo '<h4 class="box-title">'.esc_html($settings['title']).'</h4>';
									}
									if(!empty($settings['desc'])){
										echo '<span class="title">'.esc_html($settings['desc']).'</span>';
									}
									if(!empty($settings['content'])){
									echo '<div class="about-wrapp">';
										echo wp_kses_post($settings['content']);
									echo '</div>';
									}
								echo '</div>';
								if (!empty($settings['image3']['url'])) {
								echo '<div class="about17-wrapp">';
									echo '<div class="about17-img">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $settings['image3']['url']  ),
										));
									echo '</div>';
								echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_seven' ){
			echo '<div class="about16-counter-wrapp">';
				foreach( $settings['counter_lists'] as $data ){
					echo '<div class="about16-year-counter">';
						if(!empty($data['number'])){
							echo '<h3 class="about16-year-counter_number num"><span class="counter-number">'.wp_kses_post( $data['number'] ).'</span>'.wp_kses_post( $data['after_prefix'] ).'</h3>';
						}
						if(!empty($data['description'])){
							echo '<p class="about16-year-counter_text text-uppercase desc">'.wp_kses_post( $data['description'] ).'</p>';
						}
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_eight' ){
			echo '<div class="row justify-content-md-between justify-content-center gy-40">';
				foreach( $settings['counter_lists'] as $data ){
					echo '<div class="col-xl-auto col-sm-6">';
						echo '<div class="counter-card6">';
							if(!empty($data['number'])){
								echo '<h3 class="box-number num"><span class="counter-number">'.wp_kses_post( $data['number'] ).'</span>'.wp_kses_post( $data['after_prefix'] ).'</h3>';
							}
							echo '<div class="media-body">';
								if(!empty($data['description'])){
									echo '<p class="counter-text mb-n2 desc">'.esc_html( $data['description'] ).'</p>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_nine' ){
			echo '<div class="counter-area-10">';
				echo '<div class="row gy-5 justify-content-md-between justify-content-center">';
					foreach( $settings['counter_lists'] as $data ){
						echo '<div class="col-xl-3 col-md-6 counter-card10_wrapp">';
							echo '<div class="counter-card10">';
								echo '<div class="divider"></div>';
								if(!empty($data['number'])){
									echo '<h3 class="box-number num"><span class="counter-number">'.wp_kses_post( $data['number'] ).'</span>'.wp_kses_post( $data['after_prefix'] ).'</h3>';
								}
								echo '<div class="media-body">';
									if(!empty($data['description'])){
										echo '<p class="counter-text mb-n2 desc">'.wp_kses_post( $data['description'] ).'</p>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_ten' ){
			echo '<div class="row justify-content-md-between justify-content-center">';
				foreach( $settings['counter_lists'] as $data ){
					echo '<div class="col-xl-auto col-sm-6">';
						echo '<div class="counter-card11">';
							if(!empty($data['number'])){
								echo '<h3 class="box-number num"><span class="counter-number">'.wp_kses_post( $data['number'] ).'</span>'.wp_kses_post( $data['after_prefix'] ).'</h3>';
							}
							echo '<div class="media-body">';
								if(!empty($data['description'])){
									echo '<p class="box-text mb-n1 desc">'.wp_kses_post( $data['description'] ).'</p>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}


	}
}