<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Box Widget.
 *
 */
class Webteck_Currency extends Widget_Base {

	public function get_name() {
		return 'webteckcurrency';
	}
	public function get_title() {
		return __( 'Currency', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Currency', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $repeater = new Repeater();

		$repeater->add_control(
			'name',
			[
				'label'     => __( 'Name', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Name', 'webteck' )
			]
        );

		$repeater->add_control(
			'short_name',
			[
				'label'     => __( 'Short Name', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Name', 'webteck' )
			]
        );
        $repeater->add_control(
			'last_price',
			[
				'label'     => __( 'Last Price', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Last Price', 'webteck' )
			]
        );
        $repeater->add_control(
			'price_change_1h',
			[
				'label'     => __( 'Price Change in 1 hour', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Price Change in 1 hour', 'webteck' )
			]
        );
        $repeater->add_control(
			'price_change_24h',
			[
				'label'     => __( 'Price Change in 24 hour', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Price Change in 24 hour', 'webteck' )
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'graph_image',
			[
				'label' 		=> __( 'Graph Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);


		$repeater->add_control(
			'button_text',
            [
				'label'         => __( 'Button Text', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Read More' , 'webteck' ),
				'label_block'   => true,
				'rows' 			=> '2',
			]
		);
		$repeater->add_control(
			'button_link',
            [
				'label'         => __( 'Button URL', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '#' , 'webteck' ),
				'label_block'   => true,
				'rows' 			=> '2',
			]
		);
        $this->add_control(
			'features',
			[
				'label' 		=> __( 'Features', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'webteck' ),
					],
				],

			]
		);

		$this->add_control(
			'no_label',
			[
				'label'     => __( 'No. Label', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Name', 'webteck' )
			]
        );
        $this->add_control(
			'c_label',
			[
				'label'     => __( 'Cryptocurrency', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Cryptocurrency', 'webteck' )
			]
        );
        $this->add_control(
			'last_price_label',
			[
				'label'     => __( 'Last Price', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Last Price', 'webteck' )
			]
        );
        $this->add_control(
			'1h%_Change_label',
			[
				'label'     => __( '1h% Change', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '1h% Change', 'webteck' )
			]
        );
        $this->add_control(
			'24h%_Change_label',
			[
				'label'     => __( '24h% Change', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '24h% Change', 'webteck' )
			]
        );
        $this->add_control(
			'24h%_Change_label2',
			[
				'label'     => __( '24h% Change 2', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '24h% Change', 'webteck' )
			]
        );
        $this->add_control(
			'Trade_label',
			[
				'label'     => __( 'Trade', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Trade', 'webteck' )
			]
        );

		

        $this->end_controls_section();


        /*-----------------------------------------features styling------------------------------------*/
		webteck_common_style_fields($this, '01', 'Title', '{{WRAPPER}} .box-title' );
		webteck_common_style_fields($this, '02', 'Description', '{{WRAPPER}} .box-text, {{WRAPPER}} .th-desc' );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        	echo '<div class="market-list">';
                echo '<div class="market-list-area">';
                    echo '<div class="market-wrapp">';
                    	if( ! empty( $settings['no_label'] ) ){
	                        echo '<span class="number">'.esc_html( $settings['no_label'] ).'</span>';
	                    }
	                    if( ! empty( $settings['c_label'] ) ){
	                        echo '<span class="desc">'.esc_html( $settings['c_label'] ).'</span>';
	                    }
                    echo '</div>';
                    if( ! empty( $settings['last_price_label'] ) ){
	                    echo '<span class="price">'.esc_html( $settings['last_price_label'] ).'</span>';
	                }
	                if( ! empty( $settings['1h%_Change_label'] ) ){
	                    echo '<span class="change">'.esc_html( $settings['1h%_Change_label'] ).'</span>';
	                }
	                if( ! empty( $settings['24h%_Change_label'] ) ){
	                    echo '<span class="change">'.esc_html( $settings['24h%_Change_label'] ).'</span>';
	                }
	                if( ! empty( $settings['24h%_Change_label2'] ) ){
	                    echo '<span class="change">'.esc_html( $settings['24h%_Change_label2'] ).'</span>';
	                }
	                if( ! empty( $settings['Trade_label'] ) ){
	                
	                    echo '<span class="trade">'.esc_html( $settings['Trade_label'] ).'</span>';
	                }
                echo '</div>';
                
                $x = 0;
                foreach( $settings['features'] as $data ) { 
                	$x++;

	                echo '<div class="market-list-area">';
	                    echo '<div class="market-wrapp">';
	                        echo '<span class="number">'.esc_html( $x ).'.</span>';
	                        echo '<div class="profile">';
	                        	if( !empty( $data['image']['url'] ) ){
		                            echo '<div class="author">';
		                            echo webteck_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
		                            echo '</div>';
		                        }
	                            echo '<div>';
	                            	if( ! empty( $data['name'] ) ){
		                                echo '<h4 class="box-title">'.esc_html( $data['name'] ).'</h4>';
		                            }
		                            if( ! empty( $data['short_name'] ) ){
		                                echo '<span class="text">'.esc_html( $data['short_name'] ).'</span>';
		                            }
	                            echo '</div>';
	                        echo '</div>';

	                    echo '</div>';
	                    if( ! empty( $data['last_price'] ) ){
	                    	echo wp_kses_post( $data['last_price'] );
		                }
		                if( ! empty( $data['price_change_1h'] ) ){
		                    echo wp_kses_post( $data['price_change_1h'] );
		                }
		                if( ! empty( $data['price_change_24h'] ) ){
		                    echo wp_kses_post( $data['price_change_24h'] );
		                }

		                if( !empty( $data['graph_image']['url'] ) ){
                            echo '<span class="change">';
                            echo webteck_img_tag( array(
								'url'   => esc_url( $data['graph_image']['url'] ),
							) );
                            echo '</span>';
                        }

                        if( ! empty( $data['button_text'] ) ){
		                    echo '<a href="'.esc_html( $data['button_link'] ).'" class="th-btn style3 style-radius">'.esc_html( $data['button_text'] ).'</a>';
		                }
	                echo '</div>';
	            }
                

            echo '</div>';

	}
}