<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Project Box Widget .
 *
 */
class Webteck_Project extends Widget_Base {

	public function get_name() {
		return 'webteckprojects';
	}
	public function get_title() {
		return __( 'Project v2', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'projectsd_section',
			[
				'label' 	=> __( 'Project', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Project Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'webteck' ),
					'layout_two'  		=> __( 'Style Two', 'webteck' ),
					'layout_three'  	=> __( 'Style Three', 'webteck' ),
					'layout_four'  		=> __( 'Style Four', 'webteck' ),
					'layout_five'  		=> __( 'Style Five', 'webteck' ),
					'layout_six'  		=> __( 'Style Six', 'webteck' ),
					'layout_seven'  	=> __( 'Style Seven', 'webteck' ),
					'layout_eight'  	=> __( 'Style Eight', 'webteck' ),
					'layout_nine'  	=> __( 'Style Nine', 'webteck' ),
				]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'desc', [
				'label' 		=> __( 'Description', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'button_text',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
		$repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( '#', 'webteck' ),
			]
		);


		$this->add_control(
			'projects',
			[
				'label' 		=> __( 'Projects', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ title }}}',
				'condition'	=> ['layout_style' => ['layout_two']]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'desc', [
				'label' 		=> __( 'Description', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Project Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'projects3',
			[
				'label' 		=> __( 'Projects', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ title }}}',
				'condition'	=> ['layout_style' => ['layout_five', 'layout_six', 'layout_seven', 'layout_eight']]
			]
		);


		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'cat', [
				'label' 		=> __( 'Category', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::WYSIWYG,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Details Page', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( '#', 'webteck' ),
			]
		);
		$this->add_control(
			'projects2',
			[
				'label' 		=> __( 'Projects', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ title }}}',
				'condition'	=> ['layout_style' => ['layout_one','layout_three','layout_four']]
			]
		);
		$this->add_control(
			'shape',
			[
				'label' 		=> esc_html__( 'Shape Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		
		$this->add_control(
			'bg',
			[
				'label' 		=> esc_html__( 'Background', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['layout_style' => ['layout_nine']]
			]
		);

		$repeater = new Repeater();

		webteck_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA', 'Free Trial');
		webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'Start with a free trial');
		webteck_general_fields($repeater, 'content', 'Description', 'TEXTAREA', '');
		webteck_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Get started');
		webteck_url_fields($repeater, 'button_url', 'Button URL');
		webteck_media_fields($repeater, 'image', 'Choose Image');

        $this->add_control(
			'projects9',
			[
				'label' 		=> __( 'Projects', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'webteck' ),
					],
				],
				'condition'	=> ['layout_style' => ['layout_nine']]
			]
		);



        $this->end_controls_section();


        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Style', 'webteck' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		webteck_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one', 'layout_two'], '--white-color' );
		webteck_all_elementor_style($this, 'Title ', '{{WRAPPER}} .title-selector',['layout_three'], 'color' );
		webteck_all_elementor_style($this, 'Description', '{{WRAPPER}} .desc-selector',['layout_two'], '--body-color' );
 
        $this->end_controls_section();

		webteck_common_style_fields($this, 'sub', 'Subtitle', '{{WRAPPER}} .desc-selector', ['layout_five', 'layout_six', 'layout_seven']);
		webteck_common_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .title-selector', ['layout_five', 'layout_six', 'layout_seven'] );

		webteck_common_style_fields($this, '01', 'Title', '{{WRAPPER}} .title-selector', ['layout_eight'] );
		webteck_common_style_fields($this, '02', 'Description', '{{WRAPPER}} .desc-selector', ['layout_eight']);

		webteck_common_style_fields($this, '03', 'Title', '{{WRAPPER}} .sec-title', ['layout_nine']);
		webteck_common_style_fields($this, '04', 'Content', '{{WRAPPER}} .box-text', ['layout_nine'] );
		webteck_button_style_fields( $this, '11', 'Button Styling', '{{WRAPPER}} .th_btn', ['layout_nine'] );

       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
        	echo '<div class="slider-area project-slider4">'; ?>
                <div class="swiper th-slider has-shadow" id="projectSlider1" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"2"}}}'> <?php
                    echo '<div class="swiper-wrapper">';

                    	foreach( $settings['projects2'] as $data ) { 
	                        echo '<!-- Single Item -->';
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="project-box4">';
	                            	if( ! empty( $data['image']['url'] ) ){
			                            echo '<div class="project-img">';
			                                echo webteck_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
			                            echo '</div>';
			                        }
	                                echo '<div class="project-content">';
	                                    echo '<div class="media-body">';
	                                    	if( ! empty( $data['title'] ) ){
				                                echo '<h3 class="box-title title-selector"><a href="'.esc_url( $data['button_link'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
				                            }
	                                        echo '<div class="project-tags">';
	                                        echo wp_kses_post( $data['cat'] ); 

	                                        echo '</div>';
	                                    echo '</div>';

	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="slider-area">'; ?>
                <div class="swiper th-slider has-shadow" id="projectSlider1" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}'> <?php
                    echo '<div class="swiper-wrapper">';

                    	foreach( $settings['projects'] as $data ) { 
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="project-card5">';
	                            	if( ! empty( $data['image']['url'] ) ){
			                            echo '<div class="project-img">';
			                                echo webteck_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
			                            echo '</div>';
			                        }
	                                echo '<div class="project-content">';
	                                    if( ! empty( $data['title'] ) ){
			                                echo '<h3 class="box-title title-selector"><a href="'.esc_url( $data['button_link'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
			                            }
			                            if( ! empty( $data['desc'] ) ){
		                                    echo '<p class="desc-selector">'.esc_html( $data['desc'] ).'</p>';
		                                }
	                                    echo '<a href="'.esc_url( $data['button_link'] ).'" class="line-btn">'.esc_html( $data['button_text'] ).'<i class="far fa-arrow-right"></i></a>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#projectSlider1" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#projectSlider1" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_three' ){
	    	echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="projectSlider7" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['projects2'] as $data ) { 
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="project-box style2">';
	                                if( ! empty( $data['image']['url'] ) ){
			                            echo '<div class="project-img">';
			                                echo webteck_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
			                            echo '</div>';
			                        }
	                                echo '<div class="project-box_content">';
	                                	if( ! empty( $data['cat'] ) ){
		                                    echo '<p class="project-box_desc">'.esc_html( $data['cat'] ).'</p>';
		                                }
	                                    if( ! empty( $data['title'] ) ){
			                                echo '<h3 class="box-title title-selector"><a href="'.esc_url( $data['button_link'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
			                            }
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#projectSlider7" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#projectSlider7" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_four' ){
	    	echo '<div class="row gy-4 filter-active">';
                foreach( $settings['projects2'] as $data ) { 
	                echo '<div class="col-md-6 col-xxl-auto filter-item">';
	                    echo '<div class="project-card2">';
	                        if( ! empty( $data['image']['url'] ) ){
	                            echo '<div class="project-img">';
	                                echo webteck_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
	                            echo '</div>';
	                        }
	                        echo '<div class="project-content-wrap">';

	                        	$shape_iamge = $settings['shape']['url'] ? $settings['shape']['url'] : '#';

	                            echo '<div class="project-content" data-mask-src="'.esc_url( $shape_iamge ).'">';
	                            	if( ! empty( $data['cat'] ) ){
	                                    echo '<p class="project-subtitle">'.esc_html( $data['cat'] ).'</p>';
	                                }
	                                if( ! empty( $data['title'] ) ){
		                                echo '<h3 class="box-title title-selector"><a href="'.esc_url( $data['button_link'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
		                            }
	                                echo '<a href="'.esc_url( $data['image']['url'] ).'" class="icon-btn popup-image"><i class="fa-regular fa-magnifying-glass"></i></a>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_five' ){
			echo '<div class="row gy-4 filter-active">';
				foreach( $settings['projects3'] as $data ) { 
					echo '<div class="col-md-6 col-xxl-auto filter-item">';
						echo '<div class="project-card3">';
							if( ! empty( $data['image']['url'] ) ){
								echo '<div class="project-img">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
									echo '<div class="shape"></div>';
								echo '</div>';
							}
							echo '<div class="project-content">';
								echo '<a href="'.esc_url( $data['image']['url'] ).'" class="icon-btn popup-image"><i class="fa-regular fa-arrow-up-right"></i></a>';
								if( ! empty( $data['title'] ) ){
									echo '<p class="project-subtitle desc-selector">'.esc_html( $data['title'] ).'</p>';
								}
								if( ! empty( $data['desc'] ) ){
									echo '<h3 class="box-title title-selector"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['desc'] ).'</a></h3>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_six' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider" id="projectSlider9" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1","centeredSlides":"true"},"768":{"slidesPerView":"2","centeredSlides":"true"},"992":{"slidesPerView":"3","centeredSlides":"true"},"1200":{"slidesPerView":"3","centeredSlides":"true"},"1400":{"slidesPerView":"4","centeredSlides":"true"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['projects3'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="project-card style2">';
									if( ! empty( $data['image']['url'] ) ){
										echo '<div class="project-card style2">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
											echo '<div class="shape"></div>';
										echo '</div>';
									}
									echo '<div class="project-content-wrap">';
										echo '<div class="project-content">';
											if( ! empty( $data['title'] ) ){
												echo '<p class="project-subtitle desc-selector">'.esc_html( $data['title'] ).'</p>';
											}
											if( ! empty( $data['desc'] ) ){
												echo '<h3 class="box-title title-selector"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['desc'] ).'</a></h3>';
											}
											echo '<a href="'.esc_url( $data['image']['url'] ).'" class="icon-btn popup-image"><i class="fa-solid fa-arrow-up-right"></i></a>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				echo '<button data-slider-prev="#projectSlider9" class="slider-arrow style3 slider-prev"><i class="far fa-arrow-left"></i></button>';
				echo '<button data-slider-next="#projectSlider9" class="slider-arrow style3 slider-next"><i class="far fa-arrow-right"></i></button>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_seven' ){
			echo '<div class="row gy-4 filter-active">';
				foreach( $settings['projects3'] as $data ) {
					echo '<div class="col-md-6 col-xxl-auto filter-item">';
						echo '<div class="project-card style3">';
							if( ! empty( $data['image']['url'] ) ){
								echo '<div class="project-img">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
								echo '</div>';
							}
							echo '<div class="project-content-wrap">';
								echo '<div class="project-content">';
									if( ! empty( $data['title'] ) ){
										echo '<p class="project-subtitle desc-selector">'.esc_html( $data['title'] ).'</p>';
									}
									if( ! empty( $data['desc'] ) ){
										echo '<h3 class="box-title title-selector"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['desc'] ).'</a></h3>';
									}
								echo '</div>';
							echo '</div>';
							echo '<a href="'.esc_url( $data['image']['url'] ).'" class="icon-btn popup-image"><i class="fa-solid fa-arrow-up-right"></i></a>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_eight' ){
			echo '<div class="slider-area">'; 
				echo '<div class="swiper th-slider has-shadow projectSlider12" id="projectSlider12" data-slider-options=\'{"loop":true,"paginationType":"progressbar","breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['projects3'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="project-card6">';
									if( ! empty( $data['image']['url'] ) ){
										echo '<div class="project-img">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
											echo '<div class="icon"><a href="project-details.html"><i class="fa-regular fa-arrow-up-right"></i></a></div>';
										echo '</div>';
									}
									echo '<div class="project-content-wrap">';
										echo '<div class="project-content">';
											if( ! empty( $data['title'] ) ){
												echo '<h3 class="box-title title-selector"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
											}
											if( ! empty( $data['desc'] ) ){
												echo '<p class="box-text desc-selector">'.esc_html( $data['desc'] ).'</p>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<div class="slider-controller">';
						echo '<div class="slider-pagination2"></div>';
						echo '<div class="slider-pagination" data-slider-id="#projectSlider12"></div>';

						echo '<div class="icon-box">';
							echo '<button data-slider-prev="#projectSlider12" class="slider-arrow default slider-prev"><i class="fa-sharp fa-solid fa-caret-left"></i></button>';
							echo '<button data-slider-next="#projectSlider12" class="slider-arrow default slider-next"><i class="fa-sharp fa-solid fa-caret-right"></i></button>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_nine' ){
			echo '<div class="project-area13" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
				echo '<div class="row gy-3 align-items-center">';
					foreach( $settings['projects9'] as $key => $data ) {
						$even_class = ($key % 2 === 1) ? ' order-lg-4' : '';

						echo '<div class="col-lg-6 '.esc_attr($even_class).' project-item2_wrapper">';
							echo '<div class="project-item2">';
								echo '<div class="project-item2-details">';
									if( ! empty( $data['subtitle'] ) ){
										echo '<span class="sub-title sub-title9">'.esc_html( $data['subtitle'] ).'</span>';
									}
									if( ! empty( $data['title'] ) ){
										echo '<h3 class="sec-title sec-title4 mb-20">'.wp_kses_post( $data['title'] ).'</h3>';
									}
									if( ! empty( $data['content'] ) ){
										echo '<p class="box-text">'.esc_html( $data['content'] ).'</p>';
									}
									if( !empty( $data['button_text'] ) ){
										echo '<a href="'.esc_url($data['button_url']['url']).'" class="th-btn style11 text-capitalize style-radius th_btn">'.esc_html($data['button_text']).'</a>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
						echo '<div class="col-lg-6 project-item2_wrapper">';
							if( ! empty( $data['image']['url'] ) ){
								echo '<div class="process-image">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
								echo '</div>';
							}
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}


	}
}