<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Section Title Widget .
 *
 */
class Webteck_Section_Title_Widget extends Widget_Base {

	public function get_name() {
		return 'webtecksectiontitle';
	}

	public function get_title() {
		return __( 'Section Title', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Section Title', 'webteck' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
            'layout_style',
            [
                'label' => __('Select Layout', 'webteck'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' 	=> __('Layout One', 'webteck'),
                    'layout_two' 	=> __('Layout Two', 'webteck'),
                    'layout_three' 	=> __('Layout Three', 'webteck'),
                    'layout_four' 	=> __('Layout Four', 'webteck'),
                ]
            ]
        );
        $this->add_control(
			'section_subtitle',
			[
				'label' 	=> __( 'Section Subtitle', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Subtitle', 'webteck' ),
			]
        );
		$this->add_control(
			'shape',
			[
				'label' 		=> __( 'Upload Shape if Change', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition'		=> [ 
					'layout_style' => [ 'layout_three' ],
				],
			]
		);
        $this->add_control(
			'section_subtitle_tag',
			[
				'label' 	=> __( 'Subitle Tag', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'p'  => 'P',
					'span'  => 'span',
				],
				'default' 	=> 'span',
				'condition'	=> ['section_subtitle!' => '']
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Section Title', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'webteck' )
			]
        );
        $this->add_control(
			'section_title_tag',
			[
				'label' 	=> __( 'Title Tag', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'span'  => 'span',
				],
				'default' => 'h2',
			]
        );
		$this->add_control(
			'section_description',
			[
				'label' 	=> __( 'Section Description', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Description', 'webteck' )
			]
        );
        $this->add_responsive_control(
			'section_align',
			[
				'label' 		=> __( 'Alignment', 'webteck' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'webteck' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'webteck' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'webteck' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> 'left',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'text-align: {{VALUE}};',
                ]
			]
		);

        $this->end_controls_section();

       	//---------------------------------------
			//Style Section Start
		//---------------------------------------
		webteck_common_style_fields($this, 'sub2', 'Subtitle', '{{WRAPPER}} .subtitle-selector');
		webteck_common_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .title-selector');
		webteck_common_style_fields($this, 'desc2', 'Description', '{{WRAPPER}} .desc-selector' );


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( ! empty( $settings['section_description'] ) ){
        	$this->add_render_attribute( 'wrapper', 'class', 'title-area mb-25' );
        	$sec_title = 'sec-title mb-20';
        }else{
        	$this->add_render_attribute( 'wrapper', 'class', 'title-area' );
        	$sec_title = 'sec-title';
        }
		if( $settings['layout_style'] == 'layout_four'){
			$sec_title2 = ' sec-title2';
		}else{
			$sec_title2 = ' ';
		}
        
        echo '<div '.$this->get_render_attribute_string( 'wrapper' ).' >';
		    if( !empty( $settings['section_subtitle'] ) ) {
		        
		        $section_align = isset($settings['section_align']) ? $settings['section_align'] : 'left'; // Default alignment if not set
		        
		        if( $settings['layout_style'] == 'layout_one' || $settings['layout_style'] == 'layout_three' ){
		            $allign = $section_align == 'center' ? '' : 'style1';
		        } else {
		            $allign = $section_align == 'center' ? 'sub-title3' : 'sub-title3 style1';
		        }

		        echo '<'.esc_attr($settings['section_subtitle_tag']).' class="sub-title '.esc_attr( $allign ).' subtitle-selector">';
		        if( $settings['layout_style'] == 'layout_three' ){
		            echo '<div class="icon-masking me-2">';
		            if(!empty($settings['shape']['url'])){
		                echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape']['url'] ),
		                ));
		            } else {
		                echo '<img src="'.WEBTECK_ASSETS.'img/title_shape_4.svg" alt="'.esc_attr__('Shape', 'webteck').'">';
		            }
		            echo '</div>';
		        }
		        echo wp_kses_post( $settings['section_subtitle'] );
		        
		        echo '</'.esc_attr($settings['section_subtitle_tag']).'>';
		    }

		    if( ! empty( $settings['section_title'] ) ) {
		        echo '<'.esc_attr($settings['section_title_tag']).' class="'.esc_attr( $sec_title . $sec_title2 ).' title-selector">'.wp_kses_post( $settings['section_title'] ).'</'.esc_attr($settings['section_title_tag']).'>';
		    }

		    if( ! empty( $settings['section_description'] ) ){
		        echo webteck_paragraph_tag( array(
		            'text'  => wp_kses_post( $settings['section_description'] ),
		            'class' => 'desc-selector'
		        ) );
		    }
		echo '</div>';

        
        
        	
	}
}