<?php
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}
/**
 * @Packge     : Webteck
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://www.themeholy.com/
 *
 */

// enqueue css
function webteck_common_custom_css(){
	wp_enqueue_style( 'webteck-color-schemes', get_template_directory_uri().'/assets/css/color.schemes.css' );

    $CustomCssOpt  = webteck_opt( 'webteck_css_editor' );
	if( $CustomCssOpt ){
		$CustomCssOpt = $CustomCssOpt;
	} else {
		$CustomCssOpt = '';
	}

    $customcss = "";
    
    if( get_header_image() ){
        $webteck_header_bg =  get_header_image();
    } else {
        if( webteck_meta( 'page_breadcrumb_settings' ) == 'page' ){
            if( ! empty( webteck_meta( 'breadcumb_image' ) ) ){
                $webteck_header_bg = webteck_meta( 'breadcumb_image' );
            }
        }
    }
    
    if( !empty( $webteck_header_bg ) ){
        $customcss .= ".breadcumb-wrapper{
            background-image:url('{$webteck_header_bg}')!important;
        }";
    }
    
	// Theme color
	$webteckthemecolor = webteck_opt('webteck_theme_color'); 
    if( !empty( $webteckthemecolor ) ){
        list($r, $g, $b) = sscanf( $webteckthemecolor, "#%02x%02x%02x");

        $webteck_real_color = $r.','.$g.','.$b;
        if( !empty( $webteckthemecolor ) ) {
            $customcss .= ":root {
            --theme-color: rgb({$webteck_real_color});
            }";
        }
    }
	// Theme color 2
	$webteckthemecolor2 = webteck_opt('webteck_theme_color2'); 
    if( !empty( $webteckthemecolor2 ) ){
        list($r, $g, $b) = sscanf( $webteckthemecolor2, "#%02x%02x%02x");

        $webteck_real_color2 = $r.','.$g.','.$b;
        if( !empty( $webteckthemecolor2 ) ) {
            $customcss .= ":root {
            --theme-color: rgb({$webteck_real_color2});
            }";
        }
    }

    // Heading  color
	$webteckheadingcolor = webteck_opt('webteck_heading_color');
    if( !empty( $webteckheadingcolor ) ){
        list($r, $g, $b) = sscanf( $webteckheadingcolor, "#%02x%02x%02x");

        $webteck_real_color = $r.','.$g.','.$b;
        if( !empty( $webteckheadingcolor ) ) {
            $customcss .= ":root {
                --title-color: rgb({$webteck_real_color});
            }";
        }
    }

    // Body color
	$webteckbodycolor = webteck_opt('webteck_body_color');
    if( !empty( $webteckbodycolor ) ){
        list($r, $g, $b) = sscanf( $webteckbodycolor, "#%02x%02x%02x");

        $webteck_real_color = $r.','.$g.','.$b;
        if( !empty( $webteckbodycolor ) ) {
            $customcss .= ":root {
                --body-color: rgb({$webteck_real_color});
            }";
        }
    }

    // Body font
     $webteckbodyfont = webteck_opt('webteck_theme_body_font', 'font-family');
     if( !empty( $webteckbodyfont ) ) {
         $customcss .= ":root {
             --body-font: $webteckbodyfont ;
         }";
     }

     // Heading font
     $webteckheadingfont = webteck_opt('webteck_theme_heading_font', 'font-family');
     if( !empty( $webteckheadingfont ) ) {
         $customcss .= ":root {
             --title-font: $webteckheadingfont ;
         }";
     }

    if(webteck_opt('webteck_menu_icon_class')){
        $menu_icon_class = webteck_opt( 'webteck_menu_icon_class' );
    }else{
        $menu_icon_class = 'f649';
    }

    if( !empty( $menu_icon_class ) ) {
        $customcss .= ".main-menu ul.sub-menu li a:before {
                content: \"\\$menu_icon_class\" !important;
            }";
    }

	if( !empty( $CustomCssOpt ) ){
		$customcss .= $CustomCssOpt;
	}

    wp_add_inline_style( 'webteck-color-schemes', $customcss );
}
add_action( 'wp_enqueue_scripts', 'webteck_common_custom_css', 100 );