<?php
/**
 * @Packge     : Webteck
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://www.themeholy.com/
 *
 */

// Block direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$selected_options   =   get_option('et_selected_webteck_demo_plugin');

/**
 * Include File
 *
 */

// Constants
require_once get_parent_theme_file_path() . '/inc/webteck-constants.php';

//theme setup
require_once WEBTECK_DIR_PATH_INC . 'theme-setup.php';

//essential scripts
require_once WEBTECK_DIR_PATH_INC . 'essential-scripts.php';

if($selected_options == 'with_woocommerce'){

    // Woo Hooks
    require_once WEBTECK_DIR_PATH_INC . 'woo-hooks/webteck-woo-hooks.php';

    // Woo Hooks Functions
    require_once WEBTECK_DIR_PATH_INC . 'woo-hooks/webteck-woo-hooks-functions.php';
}

// plugin activation
require_once WEBTECK_DIR_PATH_FRAM . 'plugins-activation/webteck-active-plugins.php';

// theme dynamic css
require_once WEBTECK_DIR_PATH_INC . 'webteck-commoncss.php';

// meta options
require_once WEBTECK_DIR_PATH_FRAM . 'webteck-meta/webteck-config.php';

// page breadcrumbs
require_once WEBTECK_DIR_PATH_INC . 'webteck-breadcrumbs.php';

// sidebar register
require_once WEBTECK_DIR_PATH_INC . 'webteck-widgets-reg.php';

//essential functions
require_once WEBTECK_DIR_PATH_INC . 'webteck-functions.php';

// helper function
require_once WEBTECK_DIR_PATH_INC . 'wp-html-helper.php';

// Demo Data
require_once WEBTECK_DEMO_DIR_PATH . 'demo-import.php';

// pagination
require_once WEBTECK_DIR_PATH_INC . 'wp_bootstrap_pagination.php';

// webteck options
require_once WEBTECK_DIR_PATH_FRAM . 'webteck-options/webteck-options.php';

// hooks
require_once WEBTECK_DIR_PATH_HOOKS . 'hooks.php';

// hooks funtion
require_once WEBTECK_DIR_PATH_HOOKS . 'hooks-functions.php';



if ( is_admin() ) {
    include_once get_template_directory() . '/inc/webteck-dashboard/et-admin.php';
}

function webteck_enqueue_scripts() {
    wp_enqueue_style(
        'webteck-admin-styles',
        get_template_directory_uri() . '/inc/webteck-dashboard/css/admin-pages.css',
        array(),
        time()
    );
}
add_action( 'admin_enqueue_scripts', 'webteck_enqueue_scripts' );

function webteck_dashboard_submenu_page() {

    if(!function_exists('webteck_init')) {
        add_menu_page(
            esc_html__( 'ThemeHoly', 'webteck' ),
            esc_html__( 'ThemeHoly', 'webteck' ),
            'manage_options',
            'webteck-dashboard',
            '',
            get_template_directory_uri() . '/assets/img/favicon.png',
            2
        );
    }
    
    add_submenu_page(
        'webteck-dashboard',
        esc_html__( 'Dashboard', 'webteck' ),
        esc_html__( 'Dashboard', 'webteck' ),
        'manage_options',
        'webteck-dashboard',
        'webteck_screen_welcome'
    );
}
add_action( 'admin_menu', 'webteck_dashboard_submenu_page' );

function webteck_screen_welcome() {
    echo '<div class="wrap" style="height:0;overflow:hidden;"><h2></h2></div>';
    require_once get_parent_theme_file_path( '/inc/webteck-dashboard/welcome.php' );
}

function webteck_plugins_submenu_page() {

    add_submenu_page(
        'webteck-dashboard',
        esc_html__( 'Install Plugins', 'webteck' ),
        esc_html__( 'Install Plugins', 'webteck' ),
        'manage_options',
        'webteck-admin-plugins',
        'webteck_screen_plugin'
    );

}
add_action( 'admin_menu', 'webteck_plugins_submenu_page' );

function webteck_screen_plugin() {
    echo '<div class="wrap" style="height:0;overflow:hidden;"><h2></h2></div>';
    require_once get_parent_theme_file_path( '/inc/webteck-dashboard/install-plugins.php' );
}

