<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class Webteck_Banner_v4 extends Widget_Base {

	public function get_name() {
		return 'webteckbannerv4';
	}

	public function get_title() {
		return __( 'Banner Hero V2', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Banner_section',
			[
				'label' 	=> __( 'Banner', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
 
        webteck_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five', 'Style Six', 'Style Seven' ] );

		webteck_media_fields( $this, 'bg', 'Choose Background', ['1', '2','3', '4','6'] );
        webteck_media_fields( $this, 'image', 'Choose Image', ['1','3', '4', '5','6'] );
        
		webteck_general_fields( $this, 'subtitle', 'Subitle', 'TEXTAREA2', 'Welcome to Webteck Helpdesk', ['1', '4'] );
		webteck_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Need Tech Help?',['1', '2', '3', '4', '5', '6'] );
		webteck_general_fields( $this, 'desc', 'Description', 'TEXTAREA2', '', ['2','3', '4', '5','6'] );
        
		webteck_general_fields( $this, 'button_text', 'Button Text', 'TEXT', 'Get Started',['1', '2', '3', '4', '5', '6'] );
		webteck_url_fields( $this, 'button_url', 'Button URL',['1', '2', '3', '4', '5', '6'] );
		webteck_general_fields( $this, 'button_text2', 'Button Text', 'TEXT', 'Learn More', ['1', '2', '3', '4', '5'] );
		webteck_url_fields( $this, 'button_url2', 'Button URL', ['1', '2', '3', '4', '5'] );

        webteck_gallery_fields( $this, 'brand_logo', 'Client', ['3','6'] );
        webteck_general_fields( $this, 'c_text', 'Clinet Text', 'TEXTAREA2', 'Need Tech Help?', ['3'] );
        webteck_general_fields( $this, 'ratting', 'Ratting', 'TEXTAREA', 'Need Tech Help?', ['3','6'] );
        webteck_general_fields( $this, 'ratting_text', 'Ratting Text', 'TEXTAREA2', 'Need Tech Help?', ['3'] );

        webteck_general_fields( $this, 'button_text3', 'Button Text', 'TEXT', 'Get Started', ['3'] );
        webteck_url_fields( $this, 'button_url3', 'Button URL', ['3'] );

        webteck_general_fields( $this, 'v_url', 'Video Url', 'TEXTAREA2', 'Need Tech Help?', ['3','6'] );
        webteck_general_fields( $this, 'v_text', 'Video Text', 'TEXTAREA2', 'Need Tech Help?', ['3','6'] );


        $repeater = new Repeater();

        webteck_media_fields($repeater, 'image', 'Choose Image');
        webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'We offer home');
        webteck_general_fields($repeater, 'title2', 'Title 2', 'TEXTAREA', 'We offer home');
        webteck_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', '');
        webteck_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Get started');
        webteck_url_fields($repeater, 'button_url', 'Button URL');
        webteck_general_fields($repeater, 'button_text2', 'Button Text 2', 'TEXT', 'Explore All');
        webteck_url_fields($repeater, 'button_url2', 'Button URL 2');

        webteck_media_fields($repeater, 'image2', 'Client Image');
        webteck_general_fields($repeater, 'v_url', 'Video Url', 'TEXTAREA', '#');
        
        $this->add_control(
            'banner_slides7',
            [
                'label'         => __( 'Banners', 'webteck' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $repeater->get_controls(),
                'default'       => [
                    [
                        'title'     => __( 'We offer home', 'webteck' ),
                    ],
                ],
                'condition' => [
                    'layout_style' => ['7']
                ]
            ]
        );


        $repeater2 = new Repeater();

        webteck_general_fields($repeater2, 'social_name', 'Social Name', 'TEXTAREA', '10');
        webteck_general_fields($repeater2, 'social_url', 'Social Link', 'TEXTAREA', 'Year’s of Experience');
        
        $this->add_control(
            'social_media',
            [
                'label'         => __( 'Social Media', 'webteck' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $repeater2->get_controls(),
                'condition' => [
                    'layout_style' => ['7']
                ]
            ]
        );

        //Social 
        webteck_switcher_fields( $this, 'show_social', 'Show Social?', ['2'] );
		webteck_social_fields($this, 'social_lists', 'Social Lists', ['2']);

        webteck_general_fields( $this, 'idds', 'ID', 'TEXT', 'Get Started', ['6'] );

        $this->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Add Author Gallery', 'webteck' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
                'condition'	=> [
					'layout_style' => ['5'],
				]
			]
		);
        webteck_general_fields( $this, 'content', 'Content', 'TEXTAREA', '', ['5'] );
        
		// webteck_switcher_fields( $this, 'show_shape', 'Show All Shape?', ['2'] );
		
		$this->end_controls_section();


       	//---------------------------------------
			//Style Section Start
		//---------------------------------------
		webteck_common_style_fields($this, 'sub22', 'Subtitle', '{{WRAPPER}} .sub', ['1']);
		webteck_common_style_fields($this, 'title22', 'Title', '{{WRAPPER}} .title', ['1', '2', '3','6'] );
		webteck_common_style_fields($this, 'desc22', 'Description', '{{WRAPPER}} .desc', ['1', '2','3','6'] );

		//------Button Style-------
		webteck_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th_btn', ['1', '2','3','6'] );
		webteck_button_style_fields( $this, '13', 'Button Styling', '{{WRAPPER}} .th_btn2', ['1', '2','3','6'] );

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
            echo '<div class="th-hero-wrapper hero-21" id="hero" data-bg-src="'.esc_url($settings['bg']['url']).'">';
                echo '<div class="hero-inner">';
                    echo '<div class="container th-container4">';
                        echo '<div class="row justify-content-center align-items-center">';
                            echo '<div class="col-xl-6">';
                                echo '<div class="hero-style21">';
                                    if(!empty($settings['subtitle'])){
                                        echo '<span class="sub-title sub">'.wp_kses_post($settings['subtitle']).'</span>';
                                    }
                                    if(!empty($settings['title'])){
                                        echo '<h1 class="hero-title title">'.wp_kses_post($settings['title']).'</h1>';
                                    }
                                    if(!empty($settings['banner_desc'])){
                                        echo '<p class="hero-text desc">'.esc_html($settings['banner_desc']).'</p>';
                                    }
                                    echo '<div class="btn-group justify-content-center justify-content-xl-start">';
                                        if(!empty($settings['button_text'])){
                                            echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style-radius text-capitalize th_btn">'.esc_html($settings['button_text']).'</a>';
                                        }
                                        if(!empty($settings['button_text2'])){
                                            echo '<a href="'.esc_url( $settings['button_url2']['url'] ).'" class="th-btn style-radius style-border2 text-capitalize th_btn2">'.esc_html($settings['button_text2']).'</a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                            echo '<div class="col-xl-6">';
                            if (!empty($settings['image']['url'])) {
                                echo '<div class="th-hero-image">';
                                    echo '<div class="th-hero-thumb">';
                                        echo webteck_img_tag( array(
                                            'url'   => esc_url( $settings['image']['url']  ),
                                        ));
                                    echo '</div>';
                                echo '</div>';
                            }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
            echo '<div class="th-hero-wrapper hero-22" id="hero" data-bg-src="'.esc_url($settings['bg']['url']).'">';
                echo '<div class="container th-container4">';
                    echo '<div class="row align-items-end">';
                        echo '<div class="col-xl-7">';
                            echo '<div class="hero-style22">';
                                if(!empty($settings['title'])){
                                    echo '<h1 class="hero-title title">'.wp_kses_post($settings['title']).'</h1>';
                                }
                                if(!empty($settings['desc'])){
                                    echo '<p class="hero-text desc">'.esc_html($settings['desc']).'</p>';
                                }
                                echo '<div class="btn-group">';
                                    if(!empty($settings['button_text'])){
                                        echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style8 th_btn">'.esc_html($settings['button_text']).'</a>';
                                    }
                                    if(!empty($settings['button_text2'])){
                                        echo '<a href="'.esc_url( $settings['button_url2']['url'] ).'" class="th-btn style2 style-radius th_btn2">'.esc_html($settings['button_text2']).'</a>';
                                    }
                                echo '</div>';
                            echo '</div>';
        
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
                if(!empty( $settings['show_social'])){
                    echo '<div class="social-links">';
                        foreach( $settings['social_lists'] as $social_icon ){
                            $social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
                            $social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

                            echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

                            \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

                            echo '</a> ';
                        }
                    echo '</div>';
                }
            echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
            echo '<div class="th-hero-wrapper hero-23" id="hero" data-bg-src="'.esc_url($settings['bg']['url']).'">';
                echo '<div class="container th-container4">';
                    echo '<div class="row align-items-end">';
                        echo '<div class="col-xl-8">';
                            echo '<div class="hero-style23">';
                                if(!empty($settings['title'])){
                                    echo '<h1 class="hero-title title">'.wp_kses_post($settings['title']).'</h1>';
                                }
                                if(!empty($settings['desc'])){
                                    echo '<p class="hero-text desc">'.esc_html($settings['desc']).'</p>';
                                }
                                echo '<div class="btn-group">';
                                    if(!empty($settings['button_text'])){
                                        echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn btn-gradient2 style-radius th_btn">'.esc_html($settings['button_text']).'</a>';
                                    }
                                    if(!empty($settings['button_text2'])){
                                        echo '<a href="'.esc_url( $settings['button_url2']['url'] ).'" class="th-btn style-border2 style-radius text-capitalize fs-16 th_btn2">'.esc_html($settings['button_text2']).'</a>';
                                    }
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                    echo '<div class="row">';
                        echo '<div class="col-12">';
                            echo '<div class="hero-weapp">'; 
                                if (!empty($settings['image']['url'])) {
                                    echo '<div class="th-hero-img" data-mask-src="'.WEBTECK_PLUGDIRURI.'assets/img/hero-shape2.png">';
                                        echo webteck_img_tag( array(
                                            'url'   => esc_url( $settings['image']['url']  ),
                                        ));
                                    echo '</div>';
                                }
                                echo '<div class="hero-client-box movingX mb-sm-0 mb-5">';
                                    echo '<div class="client-thumb-group">';
                                        foreach ( $settings['brand_logo'] as $single_data ) {
                                            echo '<div class="thumb"><img src="'.esc_url( $single_data['url']  ).'" alt="avater"></div>';
                                        }
                                        
                                    echo '</div>';
                                    if(!empty($settings['c_text'])){
                                        echo '<h4 class="cilent-box_counter">'.wp_kses_post($settings['c_text']).'</h4>';
                                    }
                                echo '</div>';
                                echo '<div class="cilent-box">';
                                    echo '<img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/arrow4.png" alt="">';
                                    echo '<div class="hero-content">';
                                        if(!empty($settings['ratting_text'])){
                                            echo '<span class="title">'.esc_html($settings['ratting_text']).'</span>';
                                        }
                                        echo '<div class="hero-wrapp">';
                                            if(!empty($settings['ratting_text'])){
                                                echo '<div class="hero_review">';
                                                    echo wp_kses_post($settings['ratting']); 
                                                echo '</div>';
                                            }
                                            if(!empty($settings['button_text3'])){
                                                echo '<a href="'.esc_url( $settings['button_url3']['url'] ).'" class="line-btn">'.esc_html($settings['button_text3']).'<i class="fa-solid fa-angle-right"></i></a>';
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                                if(!empty($settings['v_url'])){
                                    echo '<div class="discount-wrapp">';
                                        echo '<a href="'.esc_url( $settings['v_url'] ).'" class="play-btn popup-video"><i class="fa-solid fa-play"></i></a>';
                                        echo '<div class="discount-tag">';
                                            echo '<span class="discount-anime">'.esc_html($settings['v_text']).'</span>';
                                        echo '</div>';
                                    echo '</div>';
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
                
            echo '</div>';

        }elseif( $settings['layout_style'] == '4' ){
            echo '<div class="th-hero-wrapper hero-26" id="hero" data-bg-src="'.esc_url($settings['bg']['url']).'">';
                echo '<div class="container th-container4">';
                    echo '<div class="row align-items-center">';
                        echo '<div class="col-xl-6">';
                           echo ' <div class="hero-style26">';
                                if(!empty($settings['subtitle'])){
                                    echo '<span class="sub-title sub">'.wp_kses_post($settings['subtitle']).'</span>';
                                }
                                if(!empty($settings['title'])){
                                    echo '<h1 class="hero-title title">'.wp_kses_post($settings['title']).'</h1>';
                                }
                                if(!empty($settings['desc'])){
                                    echo '<p class="hero-text desc">'.esc_html($settings['desc']).'</p>';
                                }
                                echo '<div class="btn-group justify-content-center justify-content-xl-start">';
                                    if(!empty($settings['button_text'])){
                                        echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style11 text-capitalize style-radius th_btn">'.esc_html($settings['button_text']).'</a>';
                                    }
                                    if(!empty($settings['button_text2'])){
                                        echo '<a href="'.esc_url( $settings['button_url2']['url'] ).'" class="th-btn style2 style-radius text-capitalize fs-16 th_btn2">'.esc_html($settings['button_text2']).'</a>';
                                    }
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                        echo '<div class="col-xl-6">';
                            if (!empty($settings['image']['url'])) {
                                echo '<div class="hero-image26">';
                                    echo webteck_img_tag( array(
                                        'url'   => esc_url( $settings['image']['url']  ),
                                    ));
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

        }elseif( $settings['layout_style'] == '5' ){
            echo '<div class="th-hero-wrapper hero-27" id="hero">';
                echo '<div class="container th-container6">';
                    echo '<div class="row align-items-end">';
                        echo '<div class="col-xl-6">';
                            echo '<div class="hero-style27">';
                                if(!empty($settings['title'])){
                                    echo '<h1 class="hero-title mb-10 title">'.wp_kses_post($settings['title']).'</h1>';
                                }
                                if(!empty($settings['desc'])){
                                    echo '<p class="hero-text desc">'.esc_html($settings['desc']).'</p>';
                                }
                                echo '<div class="btn-group justify-content-center justify-content-xl-start">';
                                    if(!empty($settings['button_text'])){
                                        echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style12 style-radius th_btn">'.esc_html($settings['button_text']).'</a>';
                                    }
                                    if(!empty($settings['button_text2'])){
                                        echo '<a href="'.esc_url( $settings['button_url2']['url'] ).'" class="th-btn th-border2 style-radius fs-16 th_btn2">'.esc_html($settings['button_text2']).'</a>';
                                    }
                                echo '</div>';
                                if ( ! empty( $settings['gallery'] ) && is_array( $settings['gallery'] ) || ! empty( $settings['content'] ) ) {
                                    echo '<div class="hero-client-box mb-sm-0 mb-5">';
                                        echo '<div class="client-thumb-group">';
                                            foreach ( $settings['gallery'] as $data ){
                                                echo '<div class="thumb">';
                                                    echo webteck_img_tag( array(
                                                        'url'   => esc_url( $data['url']  ),
                                                    ));
                                                echo '</div>';
                                            }
                                        echo '</div>';
                                        if(!empty($settings['content'])){
                                            echo '<span class="title">'.wp_kses_post($settings['content']).'</span>';
                                        }
                                    echo '</div>';
                                }
                            echo '</div>';
                        echo '</div>';
                        echo '<div class="col-xl-6">';
                            if (!empty($settings['image']['url'])) {
                                echo '<div class="hero-image27">';
                                    echo webteck_img_tag( array(
                                        'url'   => esc_url( $settings['image']['url']  ),
                                    ));
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

        }elseif( $settings['layout_style'] == '6' ){
            echo '<div class="th-hero-wrapper hero-27" id="hero">';
                echo '<div class="container th-container6">';
                    echo '<div class="row align-items-center">';
                        echo '<div class="col-xl-6">';
                            echo '<div class="hero-style27">';
                                if(!empty($settings['title'])){
                                    echo '<h1 class="hero-title mb-10 title">'.wp_kses_post($settings['title']).'</h1>';
                                }
                                if(!empty($settings['desc'])){
                                    echo '<p class="hero-text desc">'.esc_html($settings['desc']).'</p>';
                                }
                                echo '<div class="btn-group justify-content-center justify-content-xl-start">';
                                    if(!empty($settings['button_text'])){
                                        echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style12 th_btn style-radius">'.esc_html($settings['button_text']).'</a>';
                                    }
                                    if(!empty($settings['v_url'])){
                                        echo '<a href="'.esc_url( $settings['v_url'] ).'" class="th-btn th-border2 th_btn2 popup-video style-radius fs-16">'.esc_html($settings['v_text']).'</a>';
                                    }
                                echo '</div>';
                                echo '<div class="hero-client-box mb-sm-0 mb-5">';
                                    echo '<div class="client-thumb-group">';

                                        foreach ( $settings['brand_logo'] as $single_data ) {
                                            echo '<div class="thumb"><img src="'.esc_url( $single_data['url']  ).'" alt="avater"></div>';
                                        }
                                    echo '</div>';
                                    if(!empty($settings['ratting'])){
                                        echo wp_kses_post($settings['ratting']); 
                                    }


                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                        if (!empty($settings['image']['url'])) {
                            echo '<div class="col-xl-6">';
                                echo '<div class="hero-image27">';
                                    echo '<img src="'.esc_url($settings['image']['url']).'" alt="">';
                                    echo '<div class="hero-shape"><img src="'.esc_url($settings['bg']['url']).'" alt=""></div>';
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
                if(!empty( $settings['idds'] )){
                    echo '<div class="scroll-down">';
                        echo '<a href="'.esc_attr( $settings['idds'] ).'" class="scroll-wrap"><span></span></a>';
                    echo '</div>';
                }
            echo '</div>';
        }else{
            echo '<div class="th-hero-wrapper hero-28" id="hero">';
                echo '<div class="swiper th-slider hero-slider-1" id="heroSlide1" data-slider-options=\'{"effect":"fade","menu": ["", "", ""],"heroSlide1": {"swiper-container": {"pagination": {"el": ".swiper-pagination", "clickable": true }}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['banner_slides7'] as $data ){
                            echo '<div class="swiper-slide">';
                                echo '<div class="container th-container4">';
                                    echo '<div class="row align-items-center">';
                                        echo '<div class="col-xl-6">';
                                            echo '<div class="hero-style28">';
                                                echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">'.wp_kses_post($data['title']).'<div class="thumb"><img src="'.esc_url( $data['image2']['url'] ).'" alt="">';
                                                    if(!empty($data['v_url'])){
                                                        echo '<a href="'.esc_url( $data['v_url'] ).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
                                                    }
                                                    echo '</div>'.wp_kses_post($data['title2']).'</h1>';
                                                if(!empty($data['desc'])){
                                                    echo '<p class="hero-text" data-ani="slideinup" data-ani-delay="0.7s">'.wp_kses_post($data['desc']).'</p>';
                                                }
                                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.9s">';
                                                    if(!empty($data['button_text'])){
                                                        echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style3 text-capitalize style-radius">'.esc_html($data['button_text']).'</a>';
                                                    }
                                                    if(!empty($data['button_text2'])){
                                                        echo '<a href="'.esc_url( $data['button_url2']['url'] ).'" class="th-btn style3 text-capitalize style-radius">'.esc_html($data['button_text2']).'</a>';
                                                    }
                                                echo '</div>';
                                            echo '</div>';
                                        echo '</div>';
                                        echo '<div class="col-xl-6">';
                                            if(!empty($data['image']['url'])){
                                                echo '<div class="th-hero-img" data-ani="slideinup" data-ani-delay="0.9s">';
                                                    echo webteck_img_tag( array(
                                                        'url'   => esc_url( $data['image']['url'] ),
                                                    )); 
                                                echo '</div>';
                                            }
                                        echo '</div>';
                                   echo ' </div>';

                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                    echo '<div class="th-swiper-custom">';
                        echo '<div class="slider-pagination"></div>';
                    echo '</div>';

                echo '</div>';
                echo '<div class="hero-social">';
                    foreach( $settings['social_media'] as $data ){
                        echo '<a href="'.esc_url($data['social_url']).'">'.esc_html($data['social_name']).'</a>';
                    }
                echo '</div>';
            echo '</div>';
        }
	}
}