<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Button Widget .
 *
 */
class Webteck_Button extends Widget_Base {

	public function get_name() {
		return 'webteckbutton';
	}

	public function get_title() {
		return __( 'Button v2', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'button_section',
			[
				'label' 	=> __( 'Button', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
 		$this->add_control(
            'layout_style',
            [
                'label' => __('Select Layout', 'webteck'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'webteck'),
                    'layout_two' => __('Layout Two', 'webteck'),
                ]
            ]
        );

        $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'webteck' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Button Text', 'webteck' )
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$this->add_control(
			'button_icon',
			[
				'label' 	=> __( 'Button Icon Class', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2
			]
        );

		$this->add_control(
			'button_icon_position',
			[
				'label' 	=> __( 'Button Icon Position', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Before Text', 'webteck' ),
					'2' 		=> __( 'After Text', 'webteck' ),
				],
			]
		);

        $this->add_responsive_control(
			'button_align',
			[
				'label' 		=> __( 'Alignment', 'webteck' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'webteck' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'webteck' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'webteck' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 		=> 'left',
				'toggle' 		=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .btn-wrapper' => 'text-align: {{VALUE}}',
                ],
			]
        );

        $this->end_controls_section();

		//------Button Style-------
		webteck_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th-btn' );
      

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $this->add_render_attribute( 'wrapper', 'class', 'btn-wrapper');

		$button_align = isset($settings['button_align']) ? esc_attr($settings['button_align']) : ''; // Default to empty if not set
		$this->add_render_attribute( 'wrapper', 'class', $button_align );

		if ( $settings['layout_style'] == 'layout_two' ){
		    $this->add_render_attribute( 'button', 'class', 'th-btn style-radius' );
		} else {
		    $this->add_render_attribute( 'button', 'class', 'th-btn style6 style-radius' );
		}

		if( ! empty( $settings['button_link']['url'] ) ) {
		    $this->add_render_attribute( 'button', 'href', esc_url( $settings['button_link']['url'] ) );
		}
		if( ! empty( $settings['button_link']['nofollow'] ) ) {
		    $this->add_render_attribute( 'button', 'rel', 'nofollow' );
		}
		if( ! empty( $settings['button_link']['is_external'] ) ) {
		    $this->add_render_attribute( 'button', 'target', '_blank' );
		}

		echo '<!-- Button -->';
		echo '<div '.$this->get_render_attribute_string('wrapper').'>';

		    if( ! empty( $settings['button_text'] ) ) {
		        echo '<a '.$this->get_render_attribute_string('button').'>';
		        if( ! empty( $settings['button_icon'] ) && $settings['button_icon_position'] == '1' ){
		            echo wp_kses_post($settings['button_icon']);
		        }
		        echo esc_html( $settings['button_text'] );
		        if( ! empty( $settings['button_icon'] ) && $settings['button_icon_position'] == '2' ){
		            echo wp_kses_post($settings['button_icon']);
		        }
		        echo '</a>';
		    }
		echo '</div>';
		echo '<!-- End Button -->';

	}

}