<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Download Widget 
 *
 */
class Webteck_Download extends Widget_Base {

	public function get_name() {
		return 'webteckdownload';
	}
	public function get_title() {
		return __( 'Download', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'button_section',
			[
				'label' 	=> __( 'Button', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		webteck_select_field( $this, 'layout_style', 'Layout Style', ['Style One'] );

        webteck_media_fields($this, 'image', 'Choose Image');
		webteck_url_fields($this, 'button_url', 'Button URL');
        webteck_media_fields($this, 'image2', 'Choose Image');
		webteck_url_fields($this, 'button_url2', 'Button URL');

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		
    }

	protected function render() { 

        $settings = $this->get_settings_for_display();

        if($settings['layout_style'] == '1' ){
            echo '<div class="btn-group">';
                if( ! empty( $settings['image']['url'] ) ){
                    echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style7 style-radius">';
                        echo webteck_img_tag( array(
                            'url'       => esc_url( $settings['image']['url'] ),
                        ) );
                    echo '</a>';
                }
                if( ! empty( $settings['image2']['url'] ) ){
                echo '<a href="'.esc_url( $settings['button_url2']['url'] ).'" class="th-btn style7 style-radius">';
                    echo webteck_img_tag( array(
                        'url'       => esc_url( $settings['image2']['url'] ),
                    ) );
                echo '</a>';
                }
            echo '</div>';
        }

		
	}

}