<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Background;
/**
 * 
 * Footer Widgets .
 *
 */
class Webteck_Footer_Widgets extends Widget_Base {

	public function get_name() {
		return 'webteckfooterwidgets';
	}
	public function get_title() {
		return __( 'Footer Widgets', 'webteck' ); 
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label'     => __( 'Footer Widget Style', 'webteck' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		webteck_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five' ] );

		webteck_general_fields( $this, 'title', 'Title', 'TEXT', 'Title', ['1', '2', '5'] );
        webteck_general_fields( $this, 'desc2', 'Description', 'TEXTAREA', '', ['5'] );

        webteck_common_repeater_field($this, 'contact', 'Contact', [ 'text'  ], ['1']);
        webteck_common_repeater_field($this, 'contact2', 'Contact', [ 'icon2', 'title', 'text'  ], ['3']);

        webteck_media_fields( $this, 'image1', 'Choose Image', ['2', '4', '5'] );
        webteck_url_fields( $this, 'button_url', 'Image URL', ['2', '4', '5']);
        webteck_media_fields( $this, 'image2', 'Choose Image', ['2', '5'] );
        webteck_url_fields( $this, 'button_url2', 'Image URL', ['2', '5']);

		webteck_general_fields( $this, 'desc', 'Description', 'TEXTAREA', '', ['4'] );

		$menus = $this->webteck_menu_select();

		if ( !empty( $menus ) ){
	        $this->add_control(
				'webteck_menu_select',
				[
					'label'     	=> __( 'Select Traga Menu', 'webteck' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'webteck' ), admin_url( 'nav-menus.php' ) ),
					'condition'		=> [ 
						'layout_style' => [ '4']
					],
				]
			);
		} else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . _( 'There are no menus in your site.', 'webteck' ) . '</strong><br>' . sprintf( _( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'webteck' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
					'condition'		=> [ 
						'layout_style' => [ '4']
					],
				]
			);
		}

		$this->add_control(
			'show_social',
			[
				'label' 		=> __( 'Show Social?', 'webteck' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'webteck' ),
				'label_off' 	=> __( 'Hide', 'webteck' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'separator'		=> 'before',
				'condition'		=> [ 
					'layout_style' => [ '4']
				],
			]
		);

		webteck_social_fields($this, 'social_lists', 'Social Lists', ['4']);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
        $this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'		=> [ 
					'layout_style' => [ '1', '2']
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'webteck' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .widget_title' => 'color: {{VALUE}}',
                ],
			]
        );
		$this->add_control(
			'title_border_color',
			[
				'label' 		=> __( 'Title Border Color', 'webteck' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .widget_title' => '--theme-color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'webteck' ),
                'selector' 	=> '{{WRAPPER}} .widget_title',
			]
        );
        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Title Margin', 'webteck' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .widget_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Title Padding', 'webteck' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .widget_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->end_controls_section();


	}

	public function webteck_menu_select(){
	    $webteck_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'evona' );
	    foreach( $webteck_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		$webteck_avaiable_menu   = $this->webteck_menu_select();

		if( ! $webteck_avaiable_menu ){
			return;
		}

		$args = [
			'menu' 			=> $settings['webteck_menu_select'],
			'menu_class' 	=> 'webteck-menu',
			'container' 	=> '',
		];
		$args2 = [
			'menu' 			=> $settings['webteck_menu_select'],
			'menu_class' 	=> 'footer-menu',
			'container' 	=> '',
		];

		if( $settings['layout_style'] == '1' ){
            echo '<div class="widget footer-widget">';
                if($settings['title']){
                    echo '<h3 class="widget_title style2">'.esc_html($settings['title']).'</h3>';
                }
                echo '<div class="th-widget-about">';
                    foreach( $settings['contact'] as $data ){
                        if(!empty($data['contact_text'])){
                            echo '<p class="footer-info">'.wp_kses_post($data['contact_text']).'</p>';
                        }
                    }
                echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
            echo '<div class="widget widget_offer footer-widget">';
                if($settings['title']){
                    echo '<h3 class="widget_title style2">'.esc_html($settings['title']).'</h3>';
                }
                echo '<div class="download-btn-wrap">';
                    if(!empty($settings['image1']['url'])){
                        echo '<div class="mb-10">';
                            echo '<a target="_blank" href="'.esc_url( $settings['button_url']['url'] ).'" class="download-btn">';
                                echo webteck_img_tag( array(
                                    'url'   => esc_url( $settings['image1']['url'] ),
                                ));
                            echo '</a>';
                        echo '</div>';
                    }
                    if(!empty($settings['image2']['url'])){
                    echo '<div>';
                        echo '<a target="_blank" href="'.esc_url( $settings['button_url2']['url'] ).'" class="download-btn">';
                            echo webteck_img_tag( array(
                                'url'   => esc_url( $settings['image2']['url'] ),
                            ));
                        echo '</a>';
                    echo '</div>';
                    }
                echo '</div>';
            echo '</div>';
            
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="row gy-4 justify-content-center justify-content-lg-between">';
				foreach( $settings['contact2'] as $data ){
					echo '<div class="col-lg-auto">';
						echo '<div class="info-box">';
							if(!empty($data['contact_icon2'])){
							echo '<div class="info-box_icon">';
								echo wp_kses_post($data['contact_icon2']);
							echo '</div>';
							}
							echo '<div>';
								if(!empty($data['contact_title'])){
									echo '<span class="info-box_subtitle">'.wp_kses_post($data['contact_title']).'</span>';
								}
								if(!empty($data['contact_text'])){
									echo '<p class="info-box_text">'.wp_kses_post($data['contact_text']).'</p>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

        }elseif( $settings['layout_style'] == '4' ){
			echo '<div class="footer-top-area">';
				echo '<div class="footer-top">';
					if(!empty($settings['image1']['url'])){
						echo '<div class="footer-logo">';
							echo '<a href="'.esc_url( $settings['button_url']['url'] ).'">';
								echo webteck_img_tag( array(
									'url'   => esc_url( $settings['image1']['url'] ),
								));
							echo '</a>';
						echo '</div>';
					}
					if($settings['desc']){
						echo '<div class="">';
							echo '<p class="footer-text">'.esc_html($settings['desc']).'</p>';
						echo '</div>';
					}
				echo '</div>';
				echo '<div class="footer-menu-area">';
					if( ! empty( $settings['webteck_menu_select'] ) ){
						wp_nav_menu( $args2 );
					}
					if(!empty( $settings['show_social'])){
					echo '<div class="th-social">';
						foreach( $settings['social_lists'] as $social_icon ){
							$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
							$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

							echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

							\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
		
							echo '</a> ';
						}
					echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="widget widget_offer footer-widget">';
				if($settings['title']){
					echo '<h3 class="widget_title style2">'.esc_html($settings['title']).'</h3>';
				}
				if($settings['desc2']){
					echo '<p class="footer-text mb-30">'.esc_html($settings['desc2']).'</p>';
				}
				echo '<div class="download-btn-wrap">';
					if(!empty($settings['image1']['url'])){
						echo '<div class="mb-10">';
							echo '<a target="_blank" href="'.esc_url( $settings['button_url']['url'] ).'" class="download-btn">';
								echo webteck_img_tag( array(
									'url'   => esc_url( $settings['image1']['url'] ),
								));
							echo '</a>';
						echo '</div>';
					}
					if(!empty($settings['image2']['url'])){
					echo '<div>';
						echo '<a target="_blank" href="'.esc_url( $settings['button_url2']['url'] ).'" class="download-btn">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image2']['url'] ),
							));
						echo '</a>';
					echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}
	

	}
}
						