<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Megamenu Widget .
 *
 */
class Webteck_Megamenu extends Widget_Base {

	public function get_name() {
		return 'webteckmegamenu';
	}
	public function get_title() {
		return __( 'Megamenu Content', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'megamenu_section',
			[
				'label'		 	=> __( 'Megamenu Content', 'webteck' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		webteck_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two'] );

        webteck_general_fields($this, 'title', 'Title', 'TEXTAREA2', 'Mega Menu', ['2']);

        $repeater = new Repeater();

		webteck_media_fields($repeater, 'image', 'Choose Image');
		webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Home One');
        webteck_general_fields( $repeater, 'button_text', 'Button Text', 'TEXT', 'View Demo' );
        webteck_url_fields( $repeater, 'button_url', 'Button URL' );
		
		$this->add_control(
			'megamenu_list',
			[
				'label' 		=> __( 'Megamenu Lists', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Home', 'webteck' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'dynamic_or_custom',
			[
				'label'   => __( 'Select Type', 'webteck' ),
				'type'    => Controls_Manager::SWITCHER,
				'label_on'  => __( 'Dynamic Pages', 'webteck' ),
				'label_off' => __( 'Custom Links', 'webteck' ),
				'return_value' => 'dynamic',
				'default' => 'dynamic',
			]
		);                                                                                                                                                      
		$repeater->add_control(
			'wp_pages_list',
			[
				'label' 		=> __( 'WordPress Pages Lists', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'multiple' 		=> true,
				'label_block'   => true,
				'options' 		=> $this->get_pages_list(),
				'condition'     => [
					'dynamic_or_custom' => 'dynamic',
				]
			]
		);
		$repeater->add_control(
			'button_text',
			[
				'label' 		=> __( 'Custom Text', 'webteck' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block'   => true,
				'default' 		=> __( 'Enter your text here', 'webteck' ),
				'condition'     => [
					'dynamic_or_custom!' => 'dynamic',
				]
			]
		);
		$repeater->add_control(
			'button_url',
			[
				'label' 		=> __( 'Custom URL', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'label_block'   => true,
				'placeholder' 	=> __( 'https://your-link.com', 'webteck' ),
				'default' 		=> [
					'url' 			=> '#',
					'is_extwebteckl' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'     => [
					'dynamic_or_custom!' => 'dynamic',
				]
			]
		);

		$this->add_control(
			'megamenu_list2',
			[
				'label' 		=> __( 'Category', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

        $this->end_controls_section();

	}

	protected function get_pages_list() {
		$pages = get_pages();
		$page_array = array();
		if ( ! empty( $pages ) ) {
			foreach ( $pages as $page ) {
				$page_array[$page->ID] = $page->post_title; 
			}
		}
		return $page_array;
	}
	

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<li>';
                echo '<div class="container">';
	                echo '<div class="row gy-4">';
	                    foreach( $settings['megamenu_list'] as $data ){
		                    echo '<div class="col-lg-4">';
		                        echo '<div class="mega-menu-box">';
		                            echo '<div class="mega-menu-img">';
                                        echo webteck_img_tag( array(
                                            'url'   => esc_url( $data['image']['url'] ),
                                        )); 
                                        if(!empty($data['button_text'])){
                                            echo '<div class="btn-wrap">';
                                                echo '<a target="_blank" href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn ">'.esc_html($data['button_text']).'</a>';
                                            echo '</div>';
                                        }
		                            echo '</div>';
		                            if(!empty( $data['title'] )){
			                            echo '<h3 class="mega-menu-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.wp_kses_post( $data['title'] ).'</a></h3>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                }
	                echo '</div>';
                echo '</div>';
            echo '</li>';

		}elseif( $settings['layout_style'] == '2' ){
            echo '<div class="megamenu-list">';
                if(!empty( $settings['title'] )){
                    echo '<h3 class="mega-menu-title">'.esc_html( $settings['title'] ).'</h3>';
                }
				echo '<ul>';
					foreach ( $settings['megamenu_list2'] as $data ) {
						if ( $data['dynamic_or_custom'] === 'dynamic' ) {
							if ( ! empty( $data['wp_pages_list'] ) ) {
								foreach ( (array) $data['wp_pages_list'] as $page_id ) {
									$page_title = get_the_title( $page_id );
									$page_url = get_permalink( $page_id );
									echo '<li><a href="' . esc_url( $page_url ) . '">' . esc_html( $page_title ) . '</a></li>';
								}
							}
						} else {
							echo '<li><a href="' . esc_url( $data['button_url']['url'] ) . '">' . esc_html( $data['button_text'] ) . '</a></li>';
						}
					}
				echo '</ul>';
            echo '</div>';

        }


	}
}