<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Process Box Widget .
 *
 */
class Traga_Process extends Widget_Base {

	public function get_name() {
		return 'tragaprocess';
	}
	public function get_title() {
		return __( 'Webteck Process', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'process_section',
			[
				'label' 	=> __( 'Process', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Process Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2' 		=> __( 'Style Two', 'webteck' ),
					'3' 		=> __( 'Style Three', 'webteck' ),
					'4' 		=> __( 'Style Four', 'webteck' ),
					'5' 		=> __( 'Style Five', 'webteck' ),
					'6' 		=> __( 'Style Six', 'webteck' ),
					'7' 		=> __( 'Style Seven', 'webteck' ),
				],
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Title Area', 'webteck' )
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 4,
                'default'  	=> __( 'Content Area', 'webteck' )
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'process_line',
			[
				'label' 		=> __( 'Process Line', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['layout_style' => ['1','2']]
			]
		);
        $this->add_control(
			'process_repeat',
			[
				'label' 		=> __( 'Features', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'webteck' ),
					],
				],
				'condition'	=> ['layout_style' => ['1','2', '5','7']]
			]
		);


		$this->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SECURE & IT SERVICES' , 'webteck' ),
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['5']]
			]
        );
        $this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'SECURE & IT SERVICES' , 'webteck' ),
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['5']]
			]
        );

		$this->add_control(
            'shape',
            [
                'label'     => __( 'background Shape', 'webteck' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> ['layout_style' => ['5']]
            ]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Title Area', 'webteck' )
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 4,
                'default'  	=> __( 'Content Area', 'webteck' )
			]
        );
        
        $this->add_control(
			'process_repeat2',
			[
				'label' 		=> __( 'Step', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'webteck' ),
					],
				],
				'condition'	=> ['layout_style' => ['3']]
			]
		);


		$repeater = new Repeater();

		$repeater->add_control(
			'number',
			[
				'label'     => __( 'Number', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '01', 'webteck' )
			]
        );
		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Title Area', 'webteck' )
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 4,
                'default'  	=> __( 'Content Area', 'webteck' )
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'process_repeat3',
			[
				'label' 		=> __( 'Features', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'webteck' ),
					],
				],
				'condition'	=> ['layout_style' => ['4']]
			]
		);

		$repeater = new Repeater();

		webteck_media_fields($repeater, 'bg', 'Choose Background');
		webteck_media_fields($repeater, 'image', 'Choose Image');
		webteck_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA', 'Free Trial');
		webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'Start with a free trial');
		webteck_general_fields($repeater, 'content', 'Description', 'TEXTAREA', '');
		webteck_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'See Details');
		webteck_url_fields($repeater, 'button_url', 'Button URL');

        $this->add_control(
			'process_repeat6',
			[
				'label' 		=> __( 'Features', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'webteck' ),
					],
				],
				'condition'	=> ['layout_style' => ['6']]
			]
		);

        $this->end_controls_section();

        /*-----------------------------------------features styling------------------------------------*/
		webteck_common_style_fields($this, 'sub22', 'Section Subtitle', '{{WRAPPER}} .sub-title', ['5']);
		webteck_common_style_fields($this, 'title22', 'Section Title', '{{WRAPPER}} .sec-title', ['5'] );

		webteck_common_style_fields($this, '02', 'Title', '{{WRAPPER}} h3', ['1', '2', '3', '5', '6'] );
		webteck_common_style_fields($this, '03', 'Title', '{{WRAPPER}} .box-title', ['4','7'], '--white-color' );
		webteck_common_style_fields($this, '04', 'Content', '{{WRAPPER}} p' );

		webteck_button_style_fields( $this, '11', 'Button Styling', '{{WRAPPER}} .th_btn', ['6'] );


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if ( $settings['layout_style'] == '1' ){
        	echo '<div class="process-card-area">';
				if( ! empty( $settings['process_line']['url'] ) ){
					echo '<div class="process-line position-top">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['process_line']['url'] ),
						) );
					echo '</div>';
				}
				echo '<div class="row gy-4 justify-content-between">';
					foreach( $settings['process_repeat'] as $data ) {
						echo '<div class="col-sm-6 col-xl-auto process-card-wrap">';
							echo '<div class="process-card">';
								echo '<div class="pulse"></div>';
								if( ! empty( $data['image']['url'] ) ){
									echo '<div class="process-card_icon">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
									echo '</div>';
								}
								if( ! empty( $data['title'] ) ){
									echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
								}
								if( ! empty( $data['content'] ) ){
									echo '<p class="process-card_text">'.esc_html( $data['content'] ).'</p>';
								}
							echo '</div>';
						echo '</div>';
					}
					
				echo '</div>';
            echo '</div>';

	    } elseif ( $settings['layout_style'] == '2' ){ 
			echo '<div class="process-card-area">';
				if( ! empty( $settings['process_line']['url'] ) ){
					echo '<div class="process-line">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['process_line']['url'] ),
						) );
					echo '</div>';
				}
				echo '<div class="row gy-40">';
                    $i = 0;
					foreach( $settings['process_repeat'] as $data ) {
                        $i++;
			        	$k = str_pad($i, 2, '0', STR_PAD_LEFT);
						echo '<div class="col-sm-6 col-xl-3 process-card-wrap">';
							echo '<div class="process-card">';
								echo '<div class="process-card_number">'.esc_html($k).'</div>';
								if( ! empty( $data['image']['url'] ) ){
									echo '<div class="process-card_icon">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
									echo '</div>';
								}
								if( ! empty( $data['title'] ) ){
									echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
								}
								if( ! empty( $data['content'] ) ){
									echo '<p class="process-card_text">'.esc_html( $data['content'] ).'</p>';
								}
							echo '</div>';
						echo '</div>';
					}
					
				echo '</div>';
            echo '</div>';
			
		} elseif ( $settings['layout_style'] == '3' ){
			$i = 0;
			foreach( $settings['process_repeat2'] as $data ) {
                $i++;
				echo '<div class="process-item wp-process">';
	                echo '<span class="process-item_number">'.esc_html($i).'</span>';
	                echo '<div class="process-item_content">';
	                    echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
	                    echo '<p class="process-item_text">'.esc_html( $data['content'] ).'</p>';
	                echo '</div>';
	            echo '</div>';
	        }

		} elseif ( $settings['layout_style'] == '4' ){
			echo '<div class="process-card-area">';
				echo '<div class="row gy-40">';
					$i = 0;
					foreach( $settings['process_repeat3'] as $data ) {
						$i++;
						echo '<div class="col-md-6 col-lg-3 process-card2-wrap">';
							echo '<div class="process-card2">';
								echo '<div class="process-card2_number">'.esc_html( $data['number'] ).'</div>';
								if( ! empty( $data['image']['url'] ) ){
									echo '<div class="process-card2_icon">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
									echo '</div>';
								}
								echo '<h2 class="box-title">'.esc_html( $data['title'] ).'</h2>';
								echo '<p class="process-card2_text">'.esc_html( $data['content'] ).'</p>';
							echo '</div>';
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';
 
		}elseif ( $settings['layout_style'] == '5' ){
			echo '<div class="process-area6 space" id="process-sec" data-mask-src="'.WEBTECK_PLUGDIRURI.'assets/img/process_bg_4.png">';
				echo '<div class="container th-container4">';
					echo '<div class="row justify-content-center">';
						echo '<div class="col-lg-6">';
							echo '<div class="title-area text-center pe-xl-3 me-xl-3">';
								if(!empty($settings['subtitle'])){
									echo '<span class="sub-title sub-title3">'.wp_kses_post($settings['subtitle']).'</span>';
								}
								if(!empty($settings['title'])){
									echo '<h2 class="sec-title sec-title2">'.wp_kses_post($settings['title']).'</h2>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
		
					echo '<div class="process-card-area">';
						echo '<div class="row gy-40">';
						foreach( $settings['process_repeat'] as $data ) {
							echo '<div class="col-md-6 col-lg-3 process-card3-wrap">';
								echo '<div class="process-card3">';
									if( ! empty( $data['image']['url'] ) ){
										echo '<div class="process-card3_icon">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
										echo '</div>';
									}
									if( ! empty( $data['title'] ) ){
										echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
									}
									if( ! empty( $data['content'] ) ){
										echo '<p class="process-card3_text">'.esc_html( $data['content'] ).'</p>';
									}
								echo '</div>';
							echo '</div>';
						}
						echo '</div>';
					echo '</div>';
				echo '</div>';
				echo '<div class="shape-mockup process-shape d-none d-xl-block" data-top="0%" data-left="0%" data-bg-src="'.esc_url($settings['shape']['url']).'"></div>';
			echo '</div>';
			
		}elseif ( $settings['layout_style'] == '6' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper has-shadow processSlide">';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['process_repeat6'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="process-area-wrapper">';
									echo '<div class="process-content">';
										echo '<div class="title-area mb-15">';
											if( ! empty( $data['subtitle'] ) ){
												echo '<span class="sub-title sub-title9">'.esc_html( $data['subtitle'] ).'</span>';
											}
											if( ! empty( $data['title'] ) ){
												echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
											}
											if( ! empty( $data['content'] ) ){
												echo '<p class="box-text">'.esc_html( $data['content'] ).'</p>';
											}
										echo '</div>';
										if( !empty( $data['button_text'] ) ){
											echo '<a href="'.esc_url($data['button_url']['url']).'" class="th-btn style11 text-capitalize style-radius th_btn">'.esc_html($data['button_text']).'</a>';
										}
									echo '</div>';
									if( ! empty( $data['image']['url'] ) ){
										echo '<div class="process-image bg-theme" data-bg-src="'.esc_url( $data['bg']['url'] ).'">';
											echo webteck_img_tag( array(
												'url'   => esc_url( $data['image']['url'] ),
											) );
										echo '</div>';
									}
									echo '<div class="process-overlay"></div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';

					echo '<!-- Progress Circle and Countdown Text -->';
	                echo '<div class="autoplay-progress">';
	                    echo '<svg class="progress-circle" width="64" height="64" viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg">';
	                        echo '<circle cx="25" cy="25" r="20" stroke="#ddd" stroke-width="1" fill="none"></circle>';
	                        echo '<circle class="progress-bar" cx="25" cy="25" r="20" stroke="#356EDB" stroke-width="1" fill="none" stroke-dasharray="125.6" stroke-dashoffset="0"></circle>';
	                    echo '</svg>';
	                    echo '<span class="progress-text">0%</span>';
	                echo '</div>';

				echo '</div>';
			echo '</div>';

		}else{
			echo '<div class="process-card-area">';
                echo '<div class="row gx-70 justify-content-center">';

                    foreach( $settings['process_repeat'] as $data ) {
	                    echo '<div class="col-md-6 col-lg-4 process-card3-wrap">';
	                        echo '<div class="process-card5">';
	                        	if( ! empty( $data['image']['url'] ) ){
									echo '<div class="process-card5_img">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
									echo '</div>';
								}
	                            echo '<div class="box-content">';
	                            	if( ! empty( $data['title'] ) ){
										echo '<h2 class="box-title">'.esc_html( $data['title'] ).'</h2>';
									}
									if( ! empty( $data['content'] ) ){
		                                echo '<p class="process-card5_text">'.esc_html( $data['content'] ).'</p>';
		                            }
	                            echo '</div>';
	                       echo ' </div>';
	                    echo '</div>';
	                }
                    

                echo '</div>';
            echo '</div>';
		}


	}
}