<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
/**
 *
 * List Widget .
 *
 */
class Webteck_Text_List extends Widget_Base {

	public function get_name() {
		return 'tragatextlist';
	}

	public function get_title() {
		return __( 'Webteck Text Slider', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'list_section',
			[
				'label'     => __( 'Traga Text List', 'webteck' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'List Style', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'webteck' ),
				],
			]
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'list_text', [
				'label' 		=> esc_html__( 'List Text', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> esc_html__( 'List Text' , 'webteck' ),
				'placeholder' 	=> esc_html__( 'List Text', 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'list_repeater',
			[
				'label' 		=> __( 'List Items', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'list_text' 		=> __( 'List Item', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ list_text }}}',
			]
		);

        $this->end_controls_section();


	}

	protected function render() {
 
        $settings = $this->get_settings_for_display();

        if ( $settings['layout_style'] == '1' ) {
        	echo '<div class="marquee-area2 overflow-hidden">';
		        echo '<div class="marquee-content positive-relative overflow-hidden">';
		            echo '<div class="marquee">';
		                echo '<div class="marquee-group">';
		                	foreach( $settings['list_repeater'] as $data ) {
			                    echo '<div class="item "><img src="'.esc_url( $data['image']['url'] ).'" alt="">'.esc_html($data['list_text']).'</div>';
			                }
		                echo '</div>';
		                echo '<div aria-hidden="true" class="marquee-group">';
		                    foreach( $settings['list_repeater'] as $data ) {
			                    echo '<div class="item "><img src="'.esc_url( $data['image']['url'] ).'" alt="">'.esc_html($data['list_text']).'</div>';
			                }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}	
	}
}