<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Tab Builder Widget .
 *
 */
class Webteck_Tab_Builder extends Widget_Base {

	public function get_name() {
		return 'webtecktabbuilder';
	}
	public function get_title() {
		return __( 'Tab Builder', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
    public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'tab_builder_section',
			[
				'label' 	=> __( 'Tab Builder', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		webteck_select_field( $this, 'layout_style', 'Layout Style', ['Style One'] );


		$repeater = new Repeater();

		webteck_general_fields( $repeater, 'tab_builder_text', 'Tab Builder Title', 'TEXTAREA', 'Tab Title' );

		$repeater->add_control(
			'webteck_tab_builder_option',
			[
				'label'     => __( 'Tab Name', 'webteck' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->webteck_tab_builder_choose_option(),
				'default'	=> ''
			]
		);

		$this->add_control(
			'tab_builder_repeater',
			[
				'label' 		=> __( 'Tab', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'tab_builder_text'    => __( 'Tab Title', 'webteck' ),
					],
					
				],
				'title_field' 	=> '{{{ tab_builder_text }}}',
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

    }

	public function webteck_tab_builder_choose_option(){

		$webteck_post_query = new WP_Query( array(
			'post_type'				=> 'webteck_tab_builder',
			'posts_per_page'	    => -1,
		) );

		$webteck_tab_builder_title = array();
		$webteck_tab_builder_title[''] = __( 'Select a Tab','Foodelio');

		while( $webteck_post_query->have_posts() ) {
			$webteck_post_query->the_post();
			$webteck_tab_builder_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();

		return $webteck_tab_builder_title;

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
            echo '<div class="row justify-content-center">';
                echo '<div class="col-lg-9">';
                    echo '<div class="nav nav-tabs process-tabs" id="nav-tab" role="tablist">';
                        $x = 0;
                        foreach( $settings['tab_builder_repeater'] as $data ){
                            $x++;
                            $active = $x == '1' ? 'active':'';
                            echo '<button class="nav-link '.$active.'" id="nav-step'.esc_attr($x).'-tab" data-bs-toggle="tab" data-bs-target="#nav-step'.esc_attr($x).'" type="button"><span class="step">'.esc_html( $data['tab_builder_text'] ).'</span></button>';
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';

            echo '<div class="tab-content" id="nav-tabContent">';
                $x = 0;
                foreach( $settings['tab_builder_repeater'] as $data ){
                    $x++;
                    $active = $x == '1' ? 'active show':'';
                    echo '<div class="tab-pane fade '.$active.'" id="nav-step'.esc_attr($x).'" role="tabpanel">';
                        $elementor = \Elementor\Plugin::instance();
                        if( ! empty( $data['webteck_tab_builder_option'] ) ){
                            echo $elementor->frontend->get_builder_content_for_display( $data['webteck_tab_builder_option'] );
                        }
                    echo '</div>';
                }
            echo '</div>';

		}
		

      
	}
}