<?php
/**
 * Plugin Name: Webteck Core
 * Description: This is a helper plugin of webteck theme
 * Version:     1.0
 * Author:      Themeholy
 * Author URI:  http://angfuzsoft.com/
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 * Text Domain: webteck
 */



 // Blocking direct access

if( ! defined( 'ABSPATH' ) ) {

    exit();

}



// Define Constant

define( 'WEBTECK_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

define( 'WEBTECK_PLUGIN_INC_PATH', plugin_dir_path( __FILE__ ) . 'inc/' );
define( 'WEBTECK_PLUGIN_CMB2EXT_PATH', plugin_dir_path( __FILE__ ) . 'cmb2-ext/' );

define( 'WEBTECK_PLUGIN_WIDGET_PATH', plugin_dir_path( __FILE__ ) . 'inc/widgets/' );

define( 'WEBTECK_PLUGDIRURI', plugin_dir_url( __FILE__ ) );

define( 'WEBTECK_ADDONS', plugin_dir_path( __FILE__ ) .'addons/' );

define( 'WEBTECK_ASSETS', plugin_dir_url( __FILE__ ) .'assets/' );

define( 'WEBTECK_CORE_PLUGIN_TEMP', plugin_dir_path( __FILE__ ) .'webteck-template/' );



// load textdomain
add_action('init', function()
{
    load_plugin_textdomain('webteck', false, basename( dirname( __FILE__ ) ) . '/languages');
});
 

//include file.

require_once WEBTECK_PLUGIN_INC_PATH .'webteckcore-functions.php';
require_once WEBTECK_PLUGIN_INC_PATH .'builder/builder.php';
require_once WEBTECK_PLUGIN_INC_PATH . 'MCAPI.class.php';
require_once WEBTECK_PLUGIN_INC_PATH .'webteckajax.php';
require_once WEBTECK_PLUGIN_INC_PATH .'megamenu.php';
require_once WEBTECK_PLUGIN_INC_PATH .'webteck-elementor-functions.php';

require_once WEBTECK_PLUGIN_CMB2EXT_PATH . 'cmb2ext-init.php';



//Widget

require_once WEBTECK_PLUGIN_WIDGET_PATH . 'recent-post-widget.php';
require_once WEBTECK_PLUGIN_WIDGET_PATH . 'about-me.php';
require_once WEBTECK_PLUGIN_WIDGET_PATH . 'about-us-widget.php';
require_once WEBTECK_PLUGIN_WIDGET_PATH . 'webteck-cta.php';



//addons

require_once WEBTECK_ADDONS . 'addons.php';
require_once WEBTECK_ADDONS . 'addons-style-functions.php';
require_once WEBTECK_ADDONS . 'addons-field-functions.php';

// Register widget styles
add_action( 'elementor/editor/before_enqueue_styles', 'widget_styles' );


function widget_styles() {

    wp_register_style( 'editor-style-1', plugins_url( 'assets/css/editor.css', __FILE__ ) );
    wp_enqueue_style( 'editor-style-1' );

}


function export_pages_xml_menu() {
    add_submenu_page(
        'tools.php',             // Parent menu
        'Export Pages to XML',   // Page title
        'Export Pages',          // Menu title
        'edit_pages',            // Capability required
        'export-pages',          // Menu slug
        'export_pages_xml_page'  // Function to display the page
    );
}
add_action('admin_menu', 'export_pages_xml_menu');

// Display the page where authors can select pages for export
function export_pages_xml_page() {
    ?>
    <div class="wrap">
        <h1>Export Pages to XML</h1>
        <form method="post" action="">
            <label for="pages">Select Pages:</label>
            <select name="selected_pages[]" multiple size="10">
                <?php
                $pages = get_pages(); // Get all pages
                foreach ($pages as $page) {
                    echo '<option value="' . $page->ID . '">' . esc_html($page->post_title) . '</option>';
                }
                ?>
            </select>
            <br><br>
            <input type="submit" name="export_pages" value="Export Selected Pages to XML" class="button-primary">
        </form>
    </div>
    <?php
    if (isset($_POST['export_pages'])) {
        export_pages_xml(); // Call the function to generate the XML
    }
}

// Generate separate XML files for each selected page
// Generate WordPress-compatible XML for each selected page
function export_pages_xml() {
    // Check if the user has selected pages
    if (empty($_POST['selected_pages'])) {
        echo '<div class="error"><p>Please select at least one page to export.</p></div>';
        return;
    }

    $selected_pages = $_POST['selected_pages'];

    // Loop through the selected pages and create a WordPress-compatible XML for each
    foreach ($selected_pages as $page_id) {
        $page = get_post($page_id);
        if ($page) {
            // Create XML structure for WordPress import format
            $xml = new SimpleXMLElement('<rss version="2.0" xmlns:excerpt="http://wordpress.org/export/1.2/excerpt/" xmlns:content="http://purl.org/rss/1.0/modules/content/" xmlns:wfw="http://wellformedweb.org/CommentAPI/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:wp="http://wordpress.org/export/1.2/" />');
            $channel = $xml->addChild('channel');

            // Add general channel details
            $channel->addChild('title', get_bloginfo('name'));
            $channel->addChild('link', home_url());
            $channel->addChild('description', get_bloginfo('description'));
            $channel->addChild('pubDate', date('r'));
            $channel->addChild('language', 'en-US');
            $channel->addChild('wp:wxr_version', '1.2');

            // Add the page item
            $item = $channel->addChild('item');
            $item->addChild('title', $page->post_title);
            $item->addChild('link', get_permalink($page));
            $item->addChild('pubDate', date('r', strtotime($page->post_date)));
            $item->addChild('dc:creator', get_the_author_meta('display_name', $page->post_author));
            $item->addChild('guid', get_permalink($page));
            $item->addChild('description', '');
            $item->addChild('content:encoded', '<![CDATA[' . $page->post_content . ']]>');
            $item->addChild('excerpt:encoded', '<![CDATA[' . get_the_excerpt($page) . ']]>');
            $item->addChild('wp:post_id', $page->ID);
            $item->addChild('wp:post_date', $page->post_date);
            $item->addChild('wp:post_date_gmt', $page->post_date_gmt);
            $item->addChild('wp:comment_status', 'open');
            $item->addChild('wp:ping_status', 'open');
            $item->addChild('wp:post_name', $page->post_name);
            $item->addChild('wp:status', 'publish');
            $item->addChild('wp:post_parent', '0');
            $item->addChild('wp:menu_order', '0');
            $item->addChild('wp:post_type', 'page');
            $item->addChild('wp:post_password', '');
            $item->addChild('wp:is_sticky', '0');

            // Create a safe filename for the XML file
            $filename = sanitize_title_with_dashes($page->post_title) . '.xml';

            // Set the headers to force the download of the individual XML file
            header('Content-Type: text/xml');
            header('Content-Disposition: attachment; filename="' . $filename . '"');
            
            // Output the XML content for this page
            echo $xml->asXML();
            exit; // Exit after outputting the XML for the first page
        }
    }
}



// Security: Only allow users with 'edit_pages' capability to access the export page
function check_export_permissions() {
    if (!current_user_can('edit_pages')) {
        wp_die('You do not have sufficient permissions to access this page.');
    }
}
add_action('admin_init', 'check_export_permissions');